% qb.m  6-april-2009
% quickbird misclosure function
function result=qb(line,sample,phi,lam,ht,eph,att,par)

% put parameters into names we recognize
dx0=par(1); dx1=par(2); dx2=par(3);
dy0=par(4); dy1=par(5); dy2=par(6);
dz0=par(7); dz1=par(8); dz2=par(9);
dw0=par(10); dw1=par(11); dw2=par(12);
dp0=par(13); dp1=par(14); dp2=par(15);
dk0=par(16); dk1=par(17); dk2=par(18); 

PD = 8836.202;
% flollowing is in order qi,qj,qk,qs different from textbook
qcs1 =    -0.0037369299279122;
qcs2 =    -0.0046602381421084;
qcs3 =     0.0017171366422757;
qcs4 =     0.9999806843019142;
detOriginX =     9.5468399999999995;
detOriginY =   164.0277299999999900;
detPitch =     0.0119139600000000;
% firstLineTime = 2006-10-07T16:57:27.463116Z;
% avgLineRate = 6900.00;
% exposureDuration = 0.00188406;
% TDILevel = 13;
% startTime = 2006-10-07T16:57:21.425796Z; eph & att
% timeInterval = 0.020;
x0= -detOriginX/detPitch;
y0= -detOriginY/detPitch;
foc= PD/detPitch;
x0
y0
foc


XLe=eph(:,2);
YLe=eph(:,3);
ZLe=eph(:,4);
qie=att(:,2);
qje=att(:,3);
qke=att(:,4);
qse=att(:,5);

tes=16*3600+57*60+21.425796; % time in seconds, first ephemeris point
dte=0.02;
dt=1/6900.0;
tes

% assume line measured with line #1 = 0
t0=16*3600+57*60+27.463116; % time in seconds, first line
tline=t0 + line*dt;
t0
tline
T=tline-t0; % local time within image = independent variable for polynomials

index1=fix((tline-tes)/dte) + 1;
index2=index1+1;
t1=tes + (index1-1)*dte;
t2=t1 + dte;
delt=tline-t1;
frac=delt/dte;
index1
index2
t1
t2


XL=frac*XLe(index2) + (1-frac)*XLe(index1);
YL=frac*YLe(index2) + (1-frac)*YLe(index1);
ZL=frac*ZLe(index2) + (1-frac)*ZLe(index1);
qi=frac*qie(index2) + (1-frac)*qie(index1);
qj=frac*qje(index2) + (1-frac)*qje(index1);
qk=frac*qke(index2) + (1-frac)*qke(index1);
qs=frac*qse(index2) + (1-frac)*qse(index1);
XL
YL
ZL

len=sqrt(qi^2 + qj^2 + qk^2 + qs^2);
qi=qi/len;
qj=qj/len;
qk=qk/len;
qs=qs/len;
qi
qj
qk
qs

qcami =  qcs1;
qcamj =  qcs2;
qcamk =  qcs3;
qcams =  qcs4;

M=q2m(qi,qj,qk,qs);
Mc=q2m(qcami,qcamj,qcamk,qcams);

dX=dx0 + dx1*T + dx2*T^2;
dY=dy0 + dy1*T + dy2*T^2;
dZ=dz0 + dz1*T + dz2*T^2;
dW=dw0 + dw1*T + dw2*T^2;
dP=dp0 + dp1*T + dp2*T^2;
dK=dk0 + dk1*T + dk2*T^2;
mw=m1(dW);
mp=m2(dP);
mk=m3(dK);
Ma=mk*mp*mw;

XYZ=geo2xyz(phi,lambda,ht);
XYZ
UVW=Ma*Mc'*M'*(XYZ - [XL+dX; YL+dY; ZL+dZ]);
UVW
U=UVW(1);
V=UVW(2);
W=UVW(3);
Fx= -x0 - foc*(U/W);
Fy= -sample - y0 - foc*(V/W);
result=[Fx;Fy];
