function xyz = geo2xyz(phi,lambda,h)
% compute geocentric xyz from lat/lon
% assume wgs84

ae=6378137;
finv=298.257223563;
f=1/finv;
ee2=2*f-f^2;

xyz=zeros(3,1);
tmp=sqrt(1 - ee2*sin(phi)*sin(phi));
N=ae/tmp;
xyz(1)=(N+h)*cos(phi)*cos(lambda);
xyz(2)=(N+h)*cos(phi)*sin(lambda);
xyz(3)=(N*(1 - ee2) + h)*sin(phi);

