function latlon =  ftmgeo(x, y)
% call with x,y in meters, return lat,lon in radians 

% ellipsoid constants 

% grs80/nad83 

a=6378137.0;
f=1.0/298.257222101;

% projection constants
% for utm zone 16

cmd=87.0;
cmm=0.0;
cms=0.0;
olatd=0.0;
olatm=0.0;
olats=0.0;
scale_cm=0.9996; 
false_easting=500000.0;
false_northing=0.0;

% compute derived quantities 

b=a*(1.0-f);
e2=2.0*f - f*f;
e=sqrt(e2);
ep2=e2/(1.0-e2);
phi0   =olatd + olatm/60.0 + olats/3600.0;
lambda0=cmd   + cmm/60.0   + cms/3600.0;

% convert to radians

degrad=45.0/atan(1.0);
phi0=phi0/degrad;
lambda0=lambda0/degrad;
% assume west 
lambda0= -lambda0;

% remove offsets 

x=x - false_easting;
y=y - false_northing;

% compute some intermediate quantities 

e4=e2*e2;
e6=e4*e2;
tmp1=1.0 - sqrt(1.0 - e2);
tmp2=1.0 + sqrt(1.0 - e2);
e1=tmp1/tmp2;
e1_2=e1*e1;
e1_3=e1_2*e1;
e1_4=e1_3*e1;
tmp1=1.0 - e2/4.0 - 3.0*e4/64.0 - 5.0*e6/256.0;
tmp2=3.0*e2/8.0 + 3.0*e4/32.0 + 45.0*e6/1024.0;
tmp3=15.0*e4/256.0 + 45.0*e6/1024.0;
tmp4=35.0*e6/3072.0;
M0=a*(tmp1*phi0 - tmp2*sin(2.0*phi0) + tmp3*sin(4.0*phi0) - tmp4*sin(6.0*phi0));
k0=scale_cm;
M=M0 + y/k0;
tmp1=1.0 - e2/4.0 - 3.0*e4/64.0 -5.0*e6/256.0;
mu=M/(a*tmp1);

% get foot point latitude 

tmp1=3.0*e1/2.0 - 27.0*e1_3/32.0;
tmp2=21.0*e1_2/16.0 - 55.0*e1_4/32.0;
tmp3=151.0*e1_3/96.0;
tmp4=1097.0*e1_4/512.0;
phi1=mu + tmp1*sin(2.0*mu) + tmp2*sin(4.0*mu) + tmp3*sin(6.0*mu) + tmp4*sin(8.0*mu);

% more intermediate quantities 

C1=ep2*cos(phi1)*cos(phi1);
T1=tan(phi1)*tan(phi1);
tmp1=sqrt(1.0 - e2*sin(phi1)*sin(phi1));
N1=a/tmp1;
tmp2=tmp1*tmp1*tmp1;
R1=a*(1.0-e2)/tmp2;
D=x/(N1*k0);
D2=D*D;
D3=D2*D;
D4=D3*D;
D5=D4*D;
D6=D5*D;

% get latitude and longitude 

tmp1=N1*tan(phi1)/R1;
tmp2=D2/2.0;
tmp3=(5.0 + 3.0*T1 + 10.0*C1 - 4.0*C1*C1 - 9.0*ep2)*D4/24.0;
tmp4=(61.0 + 90.0*T1 + 298.0*C1 + 45.0*T1*T1 - 252.0*ep2 - 3.0*C1*C1);
tmp4=tmp4*D6/720.0;
phi=phi1 - tmp1*(tmp2 - tmp3 + tmp4);
phideg=phi*degrad;

tmp1=D - (1.0 + 2.0*T1 + C1)*D3/6.0;
tmp2=5.0 - 2.0*C1 + 28.0*T1 - 3.0*C1*C1 + 8.0*ep2 + 24.0*T1*T1;
tmp2=tmp2*D5/120.0;
lambda=lambda0 + (tmp1 + tmp2)/cos(phi1);
lambdadeg=lambda*degrad;
% assume west 
lambdadeg= -lambdadeg;

latlon=zeros(2,1);
latlon(1)=phi;
latlon(2)= -lambda;

% now get the scale factor 

T=tan(phi)*tan(phi);
C=ep2*cos(phi)*cos(phi);
A=(lambda - lambda0)*cos(phi);
A2=A*A;
A3=A2*A;
A4=A3*A;
A5=A4*A;
A6=A5*A;
C2=C*C;
tmp1=1.0 + (1.0 + C)*A2/2.0;
tmp2=(5.0 - 4.0*T + 42.0*C + 13.0*C2 - 28.0*ep2)*A4/24.0;
tmp3=(61.0 - 148.0*T + 16.0*T*T)*A6/720.0;
k=k0*(tmp1 + tmp2 + tmp3);
