% pltobs.m  17-feb-2014
% plot all observations from all photos in a single plot
% modify path for common m-files

pflag=2;
iw=3456;
ih=2304;

[files]=textread('phofiles.dat','%s');
[m,n]=size(files);
nph=m;

for i=1:nph
  s=char(files(i));
  [point_id,ox,oy]=textread(s,'%s %f %f');
  [mm,nn]=size(ox);
  px=zeros(mm,1);
  py=zeros(mm,1);
  for j=1:mm
    switch pflag
      case 1
        px(j)=ox(j);
        py(j)=oy(j);
      case 2
        px(j)=ox(j)-iw/2;
        py(j)= -(oy(j)-ih/2);
      case 3
        px(j)=oy(j)-iw/2;
        py(j)= -(ox(j)-ih/2);
      otherwise
      end
    end

  plot(px,py,'r+');
  if(i==1)
    hold on
    end

  end

photo_boundx=[-iw/2;-iw/2;iw/2;iw/2;-iw/2];
photo_boundy=[-ih/2;ih/2;ih/2;-ih/2;-ih/2];
plot(photo_boundx,photo_boundy,'b-');

axis equal
zoomout;
