% ccmeas7.m  4-feb-2014
% ok, i give up with universal numbers to represent intensities
% for target and background, search for min & max near target to set
% the needed constants
% take some averages to mitigate outlier effects
% needed functions: bl.m, pip.m, segint.m

% adjust background level to accommodate darker intensities
% put the constants up front

% image measurement specific for camera calibration with
% iWitness style black dots on white background
% new for this version, enter target number then
% 3 circle centers, then we generate the bounding polygon
% and compute the centroid (later find the centers by NCC)
% change from terminating with 3 flat intensities to 2
% ok - we have to terminate radial if we encounter dark level
% after white.

% in matlab, browse to folder where the images are located
% thought there was an issue with bias - turned out to be error
% in NOT converting uint8's to double before doing arithmetic
% try the rbbox = rubber band box for this version

% enter 3 approximate target centers, in order A,B,C
%
%       ***         ***
%       ***         ***
%        A           B
%
%
%       ID          ***
%                   ***
%                    C


% try to minimize use of fixed constants
thr1_frac=0.5; % define step necessary for background
bglev_tol=35; %  at least max minus this value to qualify
thr2=15; % flat tolerance
thr3=10; % overshoot tolerance
nprepix=100;
NSPOKE=32;


degrad=180/pi;
theta=0;
dtheta=(360/NSPOKE)/degrad;
uv=zeros(NSPOKE,2);
for i=1:NSPOKE
  uv(i,:)=1.415*[cos(theta) sin(theta)];
  theta=theta + dtheta;
  end
polyg=zeros(NSPOKE+1,2);
prescan=zeros(100,4);
precount=zeros(4,1);
limcount=zeros(4,1);
premax=zeros(4,1);
premin=zeros(4,1);

dc=[1;0;-1;0];
dr=[0;1;0;-1];

x1=zeros(NSPOKE,1);
y1=zeros(NSPOKE,1);
x2=zeros(NSPOKE,1);
y2=zeros(NSPOKE,1);
  
s=input('enter image filename: ','s');

% open file for coordinates
[m,n]=size(s);
so=s;
so(n-2)='t';
so(n-1)='x';
so(n)='t';
fid=fopen(so,'at');

fig = figure;
A=imread(s);
[nrow,ncol,nband]=size(A);

image(A);
axis equal
hold on

loop_break=0;
while loop_break == 0
  figure(1);
  disp('zoom/pan to next point, then press space bar');
  pause
  s1=input('enter panel ID: ','s');
  s=strtrim(s1);
  if(strcmp(s,'quit') == 1)
    close
    fclose(fid);
    return
  else
    disp('enter 3 approximate target centers');
    figure(1);
    zoom off
    pan off
    k=waitforbuttonpress;
    point1=get(gca,'currentpoint');
    disp('a');
    % plot acknowledgement
    k=waitforbuttonpress;
    point2=get(gca,'currentpoint');
    disp('b');
    % plot acknowledgement
    k=waitforbuttonpress;
    point3=get(gca,'currentpoint');
    disp('c');
    % plot acknowledgement
    point1=point1(1,1:2);
    point2=point2(1,1:2);
    point3=point3(1,1:2);

    for i=1:3
      % process each of the 3 targets
      if(i==1)
        c=point1(1);
        r=point1(2);
        ss=[s 'a'];
        end
      if(i==2)
        c=point2(1);
        r=point2(2);
        ss=[s 'b'];
        end
      if(i==3)
        c=point3(1);
        r=point3(2);
        ss=[s 'c'];
        end

      c0=c;
      r0=r;
     
      for j=1:4
        % do 4 prescans for this target to get the min & max to set needed constants
        % collect "nprepix" pixels or fewer if we run into edge of photo
        c=c0;
        r=r0;
        g0=bl(A,c,r);
        counter=1;
        prescan(counter,j)=g0;
        cont=1;
        while(cont)
          c=c+dc(j);
          r=r+dr(j);
          % limits with safety margin
          if( (c<2) | (r<2) | (c>(ncol-1)) | (r>(nrow-1)) | (counter==100) )
            cont=0;
            precount(j)=counter;
          else
            counter=counter+1;
            g=bl(A,c,r);
            prescan(counter,j)=g;
            end
          end
        end
      %precount
      %pause

      % now analyze the 4 scans
      % first find max
      limcount(1)=0;
      limcount(2)=0;
      limcount(3)=0;
      limcount(4)=0;
      for j=1:4
        mxg=0;
        for k=1:precount(j)
          g=prescan(k,j);
          if(g > mxg)            
            mxg=g;
            limcount(j)=k;
            end
          end
        premax(j)=mxg;
        end        
      % next find min (inside the max)
      for j=1:4
        mng=255;
        for k=1:limcount(j);
          g=prescan(k,j);
          if(g < mng)
            mng=g;
            end
          end
        premin(j)=mng;
        end
      mxg=(premax(1)+premax(2)+premax(3)+premax(4))/4;
      mng=(premin(1)+premin(2)+premin(3)+premin(4))/4;

      if(mxg < mng)
        % sanity check
        [mxg mng]
        disp('mxg less than mng ???');
        pause
        end

      dif=mxg-mng;
      thr1=thr1_frac*dif;
      bglev=mxg - bglev_tol;
      %pause


      % maintain pixel positions with fractional values & bilinear interpolation
      % we will have already saved c&r into c0&r0 above
      % do without fixed constants
      %c0=c;
      %r0=r;
      c=c0;
      r=r0;
      disp('reference point');
      [0 c r]
      g0=bl(A,c,r);
      sumg2=0;
      for j=1:NSPOKE
        g1=g0;
        g2=g0;
        exc=0;
        flat=0;
        c=c0;
        r=r0;
        insd=1;
        while(insd)
          csv=c;
          rsv=r;
          c=c+uv(j,1);
          r=r+uv(j,2);
          g1=g2;
          g2=bl(A,c,r);
          % enable this section to see the details of the radials
          %[j g0 g1 g2]
          %if(j==1)
          %  plot(c,r,'g.');
          %else
          %  plot(c,r,'c.');
          %  end
          %pause

          % check if we have overshot the white background
          % use dynamic thresholds here
          if((g1>bglev) && ((g1-g2) > thr3))
            insd=0;
            polyg(j,1)=csv;
            polyg(j,2)=rsv;
            g2=g1;
            %disp('********** OVERSHOOT **********');
          else
            % no overshoot - normal processing            
            % check that area is white & step up from black disk
            if ( (g2>bglev) && ((g2-g0)>thr1) )
              exc=1;
              av=(g2+g1)/2;
              % check that we have plateaued (=flat)
              if(abs(g2-g1) < thr2)
                flat=1;
                end
              end
            if(exc && flat)                
              insd=0;
              polyg(j,1)=c;
              polyg(j,2)=r;
              %[j c r]
              end
            end % else branch
          end % while doing this leg (insd=true=1)
        sumg2=sumg2 + g2;
        end % next of NSPOKE legs


      % use this later for foreground/background threshold
      avgg2=sumg2/NSPOKE;
      avgg0=bl(A,c0,r0);

      % plot the polygon
      polyg(NSPOKE+1,1)=polyg(1,1);
      polyg(NSPOKE+1,2)=polyg(1,2);
      plot(polyg(:,1),polyg(:,2),'r-');
      % make a bounding box for this target (using integer r/c)
      minc=ceil(min(polyg(:,1)));
      maxc=floor(max(polyg(:,1)));
      minr=ceil(min(polyg(:,2)));
      maxr=floor(max(polyg(:,2)));

      w=maxc-minc+1;
      h=maxr-minr+1;
      % convert polygon array into x1,y1 & x2,y2 as required by pip
      % pip = point-in-polygon
      for ii=1:NSPOKE
        x1(ii)=polyg(ii,1);
        y1(ii)=polyg(ii,2);
        x2(ii)=polyg(ii+1,1);
        y2(ii)=polyg(ii+1,2);
        end

      whi=255-avgg2;
      blk=255-avgg0;
      thresh=(whi+blk)/2;
      sumw=0;
      sumwx=0;
      sumwy=0;
      for ii=1:h
        ir=minr+ii-1;
        for jj=1:w
          % ir,ic should be integers
          ic=minc+jj-1;
          inside=pip(ic,ir,NSPOKE,x1,y1,x2,y2);
          if(inside == 1)
            g=255-(double(A(ir,ic,1))+double(A(ir,ic,2))+double(A(ir,ic,3)))/3;
            if(g > thresh)
              sumwx=sumwx + g*jj;
              sumwy=sumwy + g*ii;
              sumw=sumw + g;
              end
            end
          end
        end
      lx=sumwx/sumw;
      ly=sumwy/sumw;
      centroidx=minc + lx - 1;
      centroidy=minr + ly - 1;
      px=[centroidx-4 centroidx+4];
      py=[centroidy-4 centroidy+4];
      plot(px,py,'w-');          
      px=[centroidx-4 centroidx+4];
      py=[centroidy+4 centroidy-4];
      plot(px,py,'w-');  
      %ss
      %[centroidx centroidy]
      %sumwx
      %sumwy
      %sumw
      %whi
      %blk
      %thresh
      %keyboard
      fprintf(fid,'%s %8.1f %8.1f\n',ss,centroidx,centroidy);

      %disp('done with this target');
      %pause
      end % next of 3 targets in this panel, for i=1:3
    end % next panel
  end % while (always satisfy while test)

fclose(fid);
