% int_leq2.m  31-dec-02
% intersection equation coefficients for pseudo-linear
% formulation
% for terrestrial: generalize so we divide by largest component
% return 2 x 3 matrix and 2 x 1 vector

function [mtx,vct]=int_leq2(x,y,phoc,phoa,cm)

om=phoa(1);
ph=phoa(2);
kp=phoa(3);
x0=cm(1);
y0=cm(2);
foc=cm(3);
XL=phoc(1);
YL=phoc(2);
ZL=phoc(3);
mw=[1 0 0;0 cos(om) sin(om);0 -sin(om) cos(om)];
mp=[cos(ph) 0 -sin(ph);0 1 0;sin(ph) 0 cos(ph)];
mk=[cos(kp) sin(kp) 0;-sin(kp) cos(kp) 0;0 0 1];
m=mk*mp*mw;
%m=mw*mp*mk;
mt=m';
vc=[x-x0; y-y0; -foc];
uvw=mt*vc;

% find the largest component of the object space vector and
% divide by that component to avoid numerical problems

large_comp=0;
if((abs(uvw(1)) >= abs(uvw(2))) & (abs(uvw(1)) >= abs(uvw(3))))
  large_comp=1;
  end
if((abs(uvw(2)) >= abs(uvw(1))) & (abs(uvw(2)) >= abs(uvw(3))))
  large_comp=2;
  end
if((abs(uvw(3)) >= abs(uvw(1))) & (abs(uvw(3)) >= abs(uvw(2))))
  large_comp=3;
  end

switch large_comp
  case 1
    c1=uvw(2)/uvw(1);
    c2=uvw(3)/uvw(1);
    mtx=[c1 -1 0; c2 0 -1];
    vct=[c1*XL - YL; c2*XL - ZL];
  case 2
    c1=uvw(1)/uvw(2);
    c2=uvw(3)/uvw(2);
    mtx=[-1 c1 0; 0 c2 -1];
    vct=[c1*YL - XL; c2*YL - ZL];
  case 3
    c1=uvw(1)/uvw(3);
    c2=uvw(2)/uvw(3);
    mtx=[-1 0 c1; 0 -1 c2];
    vct=[c1*ZL - XL; c2*ZL - YL];
  otherwise
    disp('invalid case for space intersection');
    mtx=[0 0 0; 0 0 0];
    vct=[0; 0];
  end
