% collin.m  2-jan-03
% evaluate collinearity equation for given parameters
% note we are scaling the lens distortion coefficients
% for numerical stability
% you can use this for simulation by calling with x,y = 0,0
% then negate the computed x,y = -Fx,-Fy

function F=collin(p)
x=p(1);
y=p(2);
x0=p(3);
y0=p(4);
foc=p(5);
k1=p(6);
k2=p(7);
k3=p(8);
p1=p(9);
p2=p(10);
w=p(11);
h=p(12);
k=p(13);
XL=p(14);
YL=p(15);
ZL=p(16);
X=p(17);
Y=p(18);
Z=p(19);
maxr=p(20);

xp=x-x0;
yp=y-y0;
r2=xp^2 + yp^2;
r=sqrt(r2);

c1=1/(maxr^2);
c2=1/(maxr^4);
c3=1/(maxr^6);
% note: following gives problem for r=0
% dr=c1*k1*r^3 + c2*k2*r^5 + c3*k3*r^7;
% dx=dr*(xp/r);
% dy=dr*(yp/r);
% revise (equivalently) as 
%dr=c1*k1*r^2 + c2*k2*r^4 + c3*k3*r^6; % make faster eval
dr=c1*k1*r2 + c2*k2*r2^2 + c3*k3*r2^3;
dxr=dr*xp;
dyr=dr*yp;

% try this
%dxd=p1*(r2 + 2*xp^2) + 2*p2*xp*yp;
%dyd=2*p1*xp*yp + p2*(r2 + 2*yp^2);
dxd=c1*p1*(r2 + 2*xp^2) + 2*c1*p2*xp*yp;
dyd=2*c1*p1*xp*yp + c1*p2*(r2 + 2*yp^2);

xpp=xp+dxr+dxd;
ypp=yp+dyr+dyd;
mw=[1 0 0;0 cos(w) sin(w);0 -sin(w) cos(w)];
mp=[cos(h) 0 -sin(h);0 1 0;sin(h) 0 cos(h)];
mk=[cos(k) sin(k) 0;-sin(k) cos(k) 0;0 0 1];
m=mk*mp*mw;
DX=[X-XL;Y-YL;Z-ZL];
UVW=m*DX;
Fx=xpp + foc*(UVW(1)/UVW(3));
Fy=ypp + foc*(UVW(2)/UVW(3));
F=[Fx;Fy];
