% resect.m 9-oct-10
% perform space resection
% added options for image coordinates
% fixed option 3 (line, sample)
% add some output to describe convergence

degrad=180/pi;
ep=zeros(6,1);
pdel=zeros(6,1);
ip=zeros(3,1);

load cam.inp;

ep(1)=cam(1);
ep(2)=cam(2);
ep(3)=cam(3);
ep(4)=cam(4);
ep(5)=cam(5);
ep(6)=cam(6);

% inner orientation data f,xo,yo

ip(1)=cam(7);
ip(2)=cam(8);
ip(3)=cam(9);
opt=cam(10);

% deltas for numerical estimate of parameter
% partial derivatives & convergence testing

pdel(1)=4.8e-07;
pdel(2)=4.8e-07;
pdel(3)=4.8e-07;
pdel(4)=1.0e-04;
pdel(5)=1.0e-04;
pdel(6)=1.0e-04;

% read input data, text file
% point name, photo-x,y ground X,Y,Z
[pname,o1,o2,X,Y,Z]=textread('resect.inp','%s %f %f %f %f %f');

% opt=1 conv. x,y
% opt=2 photoshop x,y
% opt=3 l,s
% after this shuffle, everything is conventional x,y

switch opt
  case 1
    x=o1;
    y=o2;
  case 2
    x=o1;
    y=-o2;
    ip(2)= -ip(2);
  case 3
    x=o2;
    y= -o1;
    temp=ip(2);
    ip(2)= -ip(1);
    ip(1)=temp;
  otherwise
  end

% call the function to perform newton iteration
% with least squares estimation of corrections

par=lsq_res(ep,pdel,ip,pname,x,y,X,Y,Z);
format long g
par


