% collin.m 11-dec-00
% function to evaluate collinearity equations for a point
function F = collin(ep,ip,x,y,X,Y,Z)

x0=ip(1);
y0=ip(2);
foc=ip(3);

om=ep(1);
ph=ep(2);
kp=ep(3);
XL=ep(4);
YL=ep(5);
ZL=ep(6);

mx=[1 0 0; 0 cos(om) sin(om); 0 -sin(om) cos(om)];                              
my=[cos(ph) 0 -sin(ph); 0 1 0; sin(ph) 0 cos(ph)];                              
mz=[cos(kp) sin(kp) 0; -sin(kp) cos(kp) 0; 0 0 1];                              
m=mz*my*mx;                                                                     
uvw=m*[X-XL; Y-YL; Z-ZL];
F(1)=x(1) - x0 + foc*uvw(1)/uvw(3);
F(2)=y(1) - y0 + foc*uvw(2)/uvw(3);

