% pr10.m  12-mar-2013
% copied from pr9.m located in d:\old_d\research\rbenz\
% modify to: read RO output from ro21.m, read camera calib. data from cam.dat
% try to automate computation of viewing parameters XMIN, YMAX, NOM_PLX

% XMIN: in order to move whole image right, make this smaller (more negative)
% YMAX: in order to move whole image up, make this smaller
% NOM_PLX: locate a bright object, the red component corresponds to the
%     left image. a smaller value of this will move the left (red) image
%     to the right. (this adjustment only for eye comfort - does not
%     affect geometry)

fid=fopen('cam.dat','rt');
d=textscan(fid,'%s %f %f');
fclose(fid);
x0=d{2}(1);
y0=d{2}(2);
foc=d{2}(3);
k1=d{2}(4);
k2=d{2}(5);
k3=d{2}(6);
p1=d{2}(7);
p2=d{2}(8);
opt=d{2}(9);
ncol=d{2}(10);
nrow=d{2}(11);
if(opt ~= 2)
  disp('image observation option not valid');
  return
  end
maxr=sqrt((nrow/2)^2 + (ncol/2)^2);
[m,n]=size(d{2});
io=zeros(m+1,1);
io(1:m)=d{2};
io(m+1)=maxr;

fid=fopen('left.txt','rt');
d=textscan(fid,'%d %f %f');
fclose(fid);
pnam=d{1};
px=d{2};
py=d{3};
% assume opt=2, px,py are sample and line
[m,n]=size(px);
npnt=m;

fid=fopen('right.txt','rt');
d=textscan(fid,'%d %f %f');
fclose(fid);
pnam2=d{1};
px2=d{2};
py2=d{3};
% assume opt=2, px2,py2 are sample and line
[m,n]=size(px2);

% get results of relative orientation
fid=fopen('ro.txt','rt');
d=textscan(fid,'%f');
fclose(fid);
om1=d{1}(1);
ph1=d{1}(2);
kp1=d{1}(3);
XL1=d{1}(4);
YL1=d{1}(5);
ZL1=d{1}(6);
om2=d{1}(7);
ph2=d{1}(8);
kp2=d{1}(9);
XL2=d{1}(10);
YL2=d{1}(11);
ZL2=d{1}(12);
ref_plx=d{1}(13);

in_img1=imread('p1.jpg');
in_img2=imread('p2.jpg');
M1=m3(kp1)*m2(ph1)*m1(om1);
M2=m3(kp2)*m2(ph2)*m1(om2);

bx=XL2-XL1;
by=YL2-YL1;
bz=ZL2-ZL1;
% angles from chapter 7, page 217
thz=atan2(by,bx);
thy=atan2(-bz,sqrt(bx*bx+by*by));
% extract tertiary omegas
p= -asin(M1(1,3));
w1=atan2(M1(2,3)/cos(p),M1(3,3)/cos(p));
p= -asin(M2(1,3));
w2=atan2(M2(2,3)/cos(p),M2(3,3)/cos(p));
thx=(w1+w2)/2.0;

mx=m1(thx);
my=m2(thy);
mz=m3(thz);
mb=mx*my*mz;
% n <- p transformation
mn1=mb*M1';
mn2=mb*M2';

% compute the limits or extent of photos in normalized space

corner=zeros(4,2);
corner_n1=zeros(4,2);
corner_n2=zeros(4,2);

% upper left
corner(1,1)=1-ncol/2;
corner(1,2)=-(1-nrow/2);
% upper right
corner(2,1)=ncol-ncol/2;
corner(2,2)=-(1-nrow/2);
% lower right
corner(3,1)=ncol-ncol/2;
corner(3,2)=-(nrow-nrow/2);
% lower left
corner(4,1)=1-ncol/2;
corner(4,2)=-(nrow-nrow/2);

% project the corners

for i=1:4
  xp=[corner(i,1);corner(i,2)];
  xi=meas2refined(xp,io);
  % first the left
  uvw=mn1*[xi(1);xi(2);-foc];
  corner_n1(i,1)=-foc*(uvw(1)/uvw(3));
  corner_n1(i,2)=-foc*(uvw(2)/uvw(3));
  % then the right
  uvw=mn2*[xi(1);xi(2);-foc];
  corner_n2(i,1)=-foc*(uvw(1)/uvw(3));
  corner_n2(i,2)=-foc*(uvw(2)/uvw(3));
  end

% project the reference point, we want it to have zero parallax

i=ref_plx;
xp=zeros(2,1);

% left, l,s -> cart -> refined -> norm
xp(1)=px(i) - ncol/2;
xp(2)=-(py(i) - nrow/2);
xi=meas2refined(xp,io);
uvw=mn1*[xi(1);xi(2);-foc];
ref_n1x=-foc*(uvw(1)/uvw(3));
ref_n1y=-foc*(uvw(2)/uvw(3));

% right, ls -> cart -> refined -> norm
xp(1)=px2(i) - ncol/2;
xp(2)=-(py2(i) - nrow/2);
xi=meas2refined(xp,io);
uvw=mn2*[xi(1);xi(2);-foc];
ref_n2x=-foc*(uvw(1)/uvw(3));
ref_n2y=-foc*(uvw(2)/uvw(3));
df=ref_n2x - ref_n1x;
% subtract df/2 from right in norm. space
% add df/2 to left in norm. space
% shift the corners in x to account for this

corner_n1(:,1)=corner_n1(:,1) + df/2;
corner_n2(:,1)=corner_n2(:,1) - df/2;

YMAX=min([corner_n1(1,2) corner_n1(2,2) corner_n2(1,2) corner_n2(2,2)]);
YMIN=max([corner_n1(3,2) corner_n1(4,2) corner_n2(3,2) corner_n2(4,2)]);
XMAX=min([corner_n1(2,1) corner_n1(3,1) corner_n2(2,1) corner_n2(3,1)]);
XMIN=max([corner_n1(1,1) corner_n1(4,1) corner_n2(1,1) corner_n2(4,1)]);

%corner_n1
%corner_n2
%YMAX
%YMIN
%XMAX
%XMIN
%pause

YMAX=round(YMAX);
YMIN=round(YMIN);
XMAX=round(XMAX);
XMIN=round(XMIN);
STEP=1;
OUTROW=(YMAX-YMIN)+1;
OUTCOL=(XMAX-XMIN)+1;

vecl=zeros(3,1);
vecr=zeros(3,1);
yn=YMAX;
out_img=zeros(OUTROW,OUTCOL,3,'uint8');

for i=1:OUTROW
  % xn,yn are coordinates in the normalized frame
  disp('row');
  i
  yn=yn - STEP;
  xn=XMIN;
  for j=1:OUTCOL
    xn=xn+STEP;
    xnl=xn - df/2;
    xnr=xn + df/2;
    vecl=[xnl;yn;-foc];
    vecr=[xnr;yn;-foc];
    uvw1=mn1'*vecl;
    uvw2=mn2'*vecr;
    % project from normalized frame into photo frame(s)
    xp1=-foc*uvw1(1)/uvw1(3);
    yp1=-foc*uvw1(2)/uvw1(3);
    xp2=-foc*uvw2(1)/uvw2(3);
    yp2=-foc*uvw2(2)/uvw2(3);
    % transform ideal photo frame (cartesian) into row/colum or line/sample
    % use the io information from cam.dat
    xp1m=refined2meas([xp1;yp1],io);
    xp2m=refined2meas([xp2;yp2],io);
    col1=xp1m(1) + ncol/2;
    row1=-xp1m(2) + nrow/2;
    col2=xp2m(1) + ncol/2;
    row2=-xp2m(2) + nrow/2;
    % make nearest neighbor interpolation
    irow1=fix(row1 + 0.5);
    icol1=fix(col1 + 0.5);
    irow2=fix(row2 + 0.5);
    icol2=fix(col2 + 0.5);

    % test limits left
    intest=1;
    if((irow1 < 1) | (irow1 > (nrow)))
      intest=0;
      end
    if((icol1 < 1) | (icol1 > (ncol)))
      intest=0;
      end
    if(intest == 1)
      intensity_ui8=in_img1(irow1,icol1,1);
      red=intensity_ui8;
    else
      red=150;
      end

    % test limits right    
    intest=1;
    if((irow2 < 1) | (irow2 > (nrow)))
      intest=0;
      end
    if((icol2 < 1) | (icol2 > (ncol)))
      intest=0;
      end
    if(intest == 1)
      green=in_img2(irow2,icol2,2);
      blue=in_img2(irow2,icol2,3);
    else
      green=150;
      blue=green;
      end

    % make the anaglyph stereo output pixel
    
    out_img(i,j,1)=red;
    out_img(i,j,2)=green;
    out_img(i,j,3)=blue;
    end
  end

image(out_img);
imwrite(out_img,'pr10.jpg','JPEG');
