% inv_ld2.m  18-jan-2013
% invert lens distortion correction function by iteration
% input is ref. frame IIa, output is ref. frame II,
% and correction from III -> IV, or from II -> IIa

function res=inv_ld2(p)

xd=p(1); % destination
yd=p(2);

t=0.01; % pixel tolerance for convergence
niter=0;
keep_going=1;
while(keep_going == 1)
  niter=niter+1;
  res1=im2ideal2(p);
  corrx=res1(3);
  corry=res1(4);
  xest=p(1)+corrx;
  yest=p(2)+corry;
  % we go the opposite way from correction
  delx=xd-xest;
  dely=yd-yest;
  xnew=p(1) + delx;
  ynew=p(2) + dely;
  p(1)=xnew;
  p(2)=ynew;
  if ((abs(delx) < t) && (abs(dely) < t) && (niter <= 15))
    keep_going=0;
  elseif (niter > 15)
    keep_going=0;
    disp('we have not converged');
    pause
  else
    end
  end

res=[xnew; ynew; corrx; corry; niter];
 