% im2ideal2.m  17-jan-2013
% input is ref. frame II, output is ref. frame IV, and correction III -> IV
% include refined coords in result, not just correction
% taken from resect_sc version of collin.m
% correction adds to measured image coordinates to produce ideal image coordinates
% correction parameters are the ones one usually estimates
% distortion adds to ideal image coordinates to produce measured image coordinates
% those two have opposite sign
% normal photogrammetry apps produce the correction
% for small distortion/correction which changes gradually you can compute one and
% get the other just by negating. otherwise you have to get the other by inversion
% or by iterating. this function is just the correction function used in my photogrammetric
% routines. it will be called iteratively to obtain the distortion.

% note we are scaling the lens distortion coefficients
% for numerical stability
% keep all projection parameters in argument array even though we do not use them

function result=im2ideal2(p)
x=p(1);
y=p(2);
x0=p(3);
y0=p(4);
foc=p(5);
k1=p(6);
k2=p(7);
k3=p(8);
p1=p(9);
p2=p(10);
b1=p(11);
b2=p(12);
om=p(13);
ph=p(14);
kp=p(15);
XL=p(16);
YL=p(17);
ZL=p(18);
X=p(19);
Y=p(20);
Z=p(21);
maxr=p(22);

xp=x-x0;
yp=y-y0;
xp;
yp;
r2=xp^2 + yp^2;
r=sqrt(r2);
r;

c1=1/(maxr^2);
c2=1/(maxr^4);
c3=1/(maxr^6);
c1;
c2;
c3;
% note: following gives problem for r=0
% dr=c1*k1*r^3 + c2*k2*r^5 + c3*k3*r^7;
% dx=dr*(xp/r);
% dy=dr*(yp/r);
% revise (equivalently) as 
%dr=c1*k1*r^2 + c2*k2*r^4 + c3*k3*r^6; % make faster eval
dr=c1*k1*r2 + c2*k2*r2^2 + c3*k3*r2^3;
drr=dr;
% radial terms
dxr=dr*xp;
dyr=dr*yp;
dxr;
dyr;


% decentering or "decentring"
%dxd=p1*(r2 + 2*xp^2) + 2*p2*xp*yp;
%dyd=2*p1*xp*yp + p2*(r2 + 2*yp^2);
dxd=c1*p1*(r2 + 2*xp^2) + 2*c1*p2*xp*yp;
dyd=2*c1*p1*xp*yp + c1*p2*(r2 + 2*yp^2);
dxd;
dyd;

% in plane distortion, b1:aspect (2 scales), b2: skew
dxi=b1*xp + b2*yp;

xpp=xp+dxr+dxd+dxi;
ypp=yp+dyr+dyd;

corrx=dxr+dxd+dxi;
corry=dyr+dyd;

xpp;
ypp;



result=[xpp;ypp;corrx;corry];
