% inner_rc30.m
% compute 6-parameter transformation for inner orientation
% and then transform measured data points
% x = a0 + a1*X + a2*Y
% y = b0 + b1*X + b2*Y
% x = [ 1  X  Y  0  0  0 ] [ a0 ]
% y = [ 0  0  0  1  X  Y ] [ a1 ]
%                          [ a2 ]
%                          [ b0 ]
%                          [ b1 ]
%                          [ b2 ]

nfid=8;
calx=[-105.994;106.006;-105.993;106.005;-111.996;112.007;0.007;0.003];
caly=[-105.992;106.002;106.004;-105.992;0.010;0.007;112.004;-111.989];
x0=0.006;
y0=-0.005;
foc=153.517; % mm

s=input('enter your (input) filename: ','s');
h=input('enter mean terrain height (m): ');
H=input('enter approx. flying height (m): ');
% convert to km
h=h/1000.0;
H=H/1000.0;

[id,line,sample]=textread(s,'%s %f %f');
[m,n]=size(line);
ndata=m-nfid;

B=zeros(2*nfid,6);
f=zeros(2*nfid,1);
for i=1:nfid
  ii=(i-1)*2 + 1;
  B(ii,:)=[1 calx(i) caly(i) 0 0 0];
  f(ii)=line(i);
  B(ii+1,:)=[0 0 0 1 calx(i) caly(i)];
  f(ii+1)=sample(i);  
  end

disp('6-parameter results');
p=inv(B'*B)*B'*f
disp('residuals (pixels)');
resid=f - B*p;
for i=1:nfid
  ii=(i-1)*2 + 1;
  vx=resid(ii);
  vy=resid(ii+1);
  [ss,serr]=sprintf('%d %f %f',i,vx,vy);
  disp(ss);
  end

% compute the nonlinear parameters
% scale-x, scale-y, genral rotation (theta), non-orthogonality (alpha)
a0=p(1);
a1=p(2);
a2=p(3);
b0=p(4);
b1=p(5);
b2=p(6);
disp('physical parameters');
scale_x=sqrt(a1^2 + b1^2)
scale_y=sqrt(a2^2 + b2^2)
theta=atan2(-b1,a1)
thetad=theta*(180/pi)
alpha=atan((a1*a2+b1*b2)/(a1*b2-a2*b1))
alphad=alpha*(180/pi)

% invert and apply to measurements (l,s) -> (x,y)
% also apply offset to PPS

xy=zeros(2,ndata);
xy_ref=zeros(2,ndata); 
ii=9;
for i=1:ndata
  xy(:,i)=inv([p(2) p(3); p(5) p(6)])*([line(ii);sample(ii)] - [p(1); p(4)]);
  xy(:,i)=[xy(1,i)-x0; xy(2,i)-y0];
  ii=ii+1;
  end

% now lens distortion correction
% these parameters from usgs report are for correction vector

k0=0.6397e-04;
k1=-0.1379e-07;
k2=0.5948e-12;

p1=0.1190e-06;
p2=0.1787e-06;

disp('radial correction / decentering correction (mm)');
for i=1:ndata
  x=xy(1,i);
  y=xy(2,i);
  r=sqrt(x^2+y^2);
  dr=k0*r + k1*r^3 + k2*r^5;
  % so we don't divide by zero at origin
  if(r < 1.0e-06)
    dxp=0;
    dyp=0;
  else
    dxp=x*(dr/r);
    dyp=y*(dr/r);
    end
  dxpp=p1*(r^2 + 2*x^2) + 2*p2*x*y;
  dypp=2*p1*x*y + p2*(r^2 + 2*y^2);
  xy_ref(1,i)=x + dxp + dxpp;
  xy_ref(2,i)=y + dyp + dypp;
  [ss,serr]=sprintf('%d %f %f',i,dxp,dyp);
  disp(ss);
  [ss,serr]=sprintf('%d %f %f',i,dxpp,dypp);
  disp(ss);  
  end

% now correct for atmospheric refraction
% here we assume radial correction always inward
% note: this is not right if significant tilt

K=(2410*H)/(H^2-6*H+250) - ((2410*h)/(h^2-6*h+250))*(h/H);
K=K*1.0e-06;

disp('atmospheric refraction correction (mm)');
for i=1:ndata
  x=xy_ref(1,i);
  y=xy_ref(2,i);
  r=sqrt(x^2 + y^2);
  dr=(r + r^3/foc^2)*K;
  if(r < 1.0e-06)
    dxppp=0;
    dyppp=0;
  else
    dxppp=-x*dr/r;
    dyppp=-y*dr/r;
    end
  xy_ref(1,i)=x + dxppp;
  xy_ref(2,i)=y + dyppp;
  [ss,serr]=sprintf('%d %f %f',i,dxppp,dyppp);
  disp(ss);
  end

fid=fopen('inner_rc30.out','wt');
ii=9;
for i=1:ndata
  s=char(id(ii));
  fprintf(fid,'%s %12.3f %12.3f\n',s,xy_ref(1,i),xy_ref(2,i));
  ii=ii+1;
  end
fclose(fid);
