% L1.m  27-may-2011
% implement L1 norm minimization adjustment for 
% indirect observation model (v + B*del = f)
% output are parameters, x, and residuals, v.
% some debug output enabled which needs to disappear
% when done debugging

function [x,v]=L1(B,f)

[n,u]=size(B);

% rename some things

b=f;                                %fill b matrix
f=[zeros(1,2*u) ones(1,2*n)];       %fill f' (Objective function)
% create slack variables for the parameters and residuals
for i=1:n
  for j=1:u
    A(i,2*j-1)=B(i,j);
    A(i,2*j)=-B(i,j);
    end
  A(i,2*u+2*i-1)=1;
  A(i,2*u+2*i)=-1;
  end

%A
%b
%f
%pause

%T=lp(f,A,b,zeros(2*u+2*n,1),[],[],n);   %use lp (obsolete) function

options = optimset('LargeScale', 'off', 'Simplex', 'on');
x0=zeros(2*u + 2*n,1);
T=linprog(f,[],[],A,b,zeros(2*u + 2*n,1),Inf,x0,options);   %use linprog (new) function
%T
z=f*T

% calculate parameters

for j=1:u
  x(j)=T(2*j-1)-T(2*j);
  end;

% calculate residuals

for j=1:n
  v(j)=T(2*u+2*j-1)-T(2*u+2*j);
  end

x=x';
v=v';
