function varargout = netgui1(varargin)
% NETGUI1 Application M-file for netgui1.fig
%    FIG = NETGUI1 launch netgui1 GUI.
%    NETGUI1('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 23-Nov-2002 16:42:15

if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
	catch
		disp(lasterr);
	end

end


%| ABOUT CALLBACKS:
%| GUIDE automatically appends subfunction prototypes to this file, and 
%| sets objects' callback properties to call them through the FEVAL 
%| switchyard above. This comment describes that mechanism.
%|
%| Each callback subfunction declaration has the following form:
%| <SUBFUNCTION_NAME>(H, EVENTDATA, HANDLES, VARARGIN)
%|
%| The subfunction name is composed using the object's Tag and the 
%| callback type separated by '_', e.g. 'slider2_Callback',
%| 'figure1_CloseRequestFcn', 'axis1_ButtondownFcn'.
%|
%| H is the callback object's handle (obtained using GCBO).
%|
%| EVENTDATA is empty, but reserved for future use.
%|
%| HANDLES is a structure containing handles of components in GUI using
%| tags as fieldnames, e.g. handles.figure1, handles.slider2. This
%| structure is created at GUI startup using GUIHANDLES and stored in
%| the figure's application data using GUIDATA. A copy of the structure
%| is passed to each callback.  You can store additional information in
%| this structure at GUI startup, and you can change the structure
%| during callbacks.  Call guidata(h, handles) after changing your
%| copy to replace the stored original so that subsequent callbacks see
%| the updates. Type "help guihandles" and "help guidata" for more
%| information.
%|
%| VARARGIN contains any extra arguments you have passed to the
%| callback. Specify the extra arguments by editing the callback
%| property in the inspector. By default, GUIDE sets the property to:
%| <MFILENAME>('<SUBFUNCTION_NAME>', gcbo, [], guidata(gcbo))
%| Add any extra arguments after the last argument, before the final
%| closing parenthesis.



% --------------------------------------------------------------------
function varargout = getpointfile_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.getpointfile.
[filename,pathname]=uigetfile({'*.*','All Files (*.*)'},'Select File');
if filename ~= 0
  set(handles.edit_pointfile,'string',strcat(pathname,filename));
else
  set(handles.edit_pointfile,'string','');
  end

% --------------------------------------------------------------------
function varargout = edit_pointfile_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.edit_pointfile.

% --------------------------------------------------------------------
function varargout = getobsfile_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.getobsfile.
[filename,pathname]=uigetfile({'*.*','All Files (*.*)'},'Select File');
if filename ~= 0
  set(handles.edit_obsfile,'string',strcat(pathname,filename));
else
  set(handles.edit_obsfile,'string','');
  end

% --------------------------------------------------------------------
function varargout = edit_obsfile_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.edit_obsfile.

% --------------------------------------------------------------------
function varargout = edit_dsig_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.edit_dsig.

% --------------------------------------------------------------------
function varargout = edit_angsig_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.edit_angsig.

% --------------------------------------------------------------------
function varargout = edit_azsig_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.edit_azsig.

% --------------------------------------------------------------------
function varargout = run_button_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.run_button.

% get sigmas from screen dialogue boxes

set(handles.message_text,'string','                ');
s1=get(handles.edit_dsig,'string');
dsig=str2double(s1);
test=isnan(dsig);
if test == 1
  set(handles.message_text,'string','bad dist sigma');
  break;
else
end

degrad=180/pi;
s1=get(handles.edit_angsig,'string');
sec=str2double(s1);
test=isnan(sec);
if test == 1
  set(handles.message_text,'string','bad angle sigma');
  break;
else
  angsig=(sec/3600)/degrad;
end

s1=get(handles.edit_azsig,'string');
sec=str2double(s1);
test=isnan(sec);
if test == 1
  set(handles.message_text,'string','bad azm sigma');
  break;  
else
  azsig=(sec/3600)/degrad;
end

sig0_sqr=1.0;

% open and read the point file

pfilename=get(handles.edit_pointfile,'string');
[pnum,px,py,cflag]=textread(pfilename,'%f %f %f %f');
[numpnt,n]=size(pnum);

% make index arrays to relate point list and unkown parameter list

ii=0;
for i=1:numpnt
  ptou(i)=0;
  if(cflag(i) ~= 1)
    ii=ii+1;
    ptou(i)=ii;  % point list to unknown list
    utop(ii)=i;  % unknown list to point list
    end
  end
numunkpnt=ii;
numunk=numunkpnt*2;

% open and read the observation file

ofilename=get(handles.edit_obsfile,'string');
[obs_type,oi,oj,ok,ob1,ob2,ob3]=textread(ofilename,'%s %f %f %f %f %f %f');
[numobs,n]=size(obs_type);
r=numobs - numunk;

% fill in the weight matrix

W=zeros(numobs,numobs);
for i=1:numobs
  obs_str=char(obs_type(i));
  switch obs_str
    case 'D'
      W(i,i)=sig0_sqr/dsig^2;
    case 'A'
      W(i,i)=sig0_sqr/angsig^2;
    case 'Z'
      W(i,i)=sig0_sqr/azsig^2;
    otherwise
    end 
  end

old_vTWv=9.999e+06;
for iter=1:10
  iter
  B=zeros(numobs,numunk);
  f=zeros(numobs,1);
  for i=1:numobs
    obs_str=char(obs_type(i));  
    switch obs_str
      case 'D'
        indx=idtop(pnum,oi(i));
        jndx=idtop(pnum,oj(i));
        [b,F]=dis_cond_eqn(px,py,indx,jndx,ob1(i));
        up=ptou(indx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(1);
          B(i,(up-1)*2+2)=b(2);
          end
        up=ptou(jndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(3);
          B(i,(up-1)*2+2)=b(4);
          end
        f(i)=-F;
      case 'A'
        indx=idtop(pnum,oi(i));
        jndx=idtop(pnum,oj(i));
        kndx=idtop(pnum,ok(i));
        [b,F]=ang_cond_eqn(px,py,indx,jndx,kndx,ob1(i),ob2(i),ob3(i));
        up=ptou(indx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(1);
          B(i,(up-1)*2+2)=b(2);
          end
        up=ptou(jndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(3);
          B(i,(up-1)*2+2)=b(4);
          end
        up=ptou(kndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(5);
          B(i,(up-1)*2+2)=b(6);
          end
        f(i)=-F;
      case 'Z'
        indx=idtop(pnum,oi(i));
        jndx=idtop(pnum,oj(i));
        [b,F]=az_cond_eqn(px,py,indx,jndx,ob1(i),ob2(i),ob3(i));
        up=ptou(indx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(1);
          B(i,(up-1)*2+2)=b(2);
          end
        up=ptou(jndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(3);
          B(i,(up-1)*2+2)=b(4);
          end
        f(i)=-F;
      otherwise
      end        
    end

  N=B'*W*B;
  t=B'*W*f;
  del=inv(N)*t
  for i=1:numunkpnt
    np=utop(i);
    px(np)=px(np) + del((i-1)*2+1);
    py(np)=py(np) + del((i-1)*2+2);
    end
  % check for convergence
  
  v=f - B*del;
  vTWv=v'*W*v;
  frac_chg=abs(old_vTWv - vTWv)/vTWv;
  conv=0;
  if frac_chg < 0.0001
    disp('we have converged');
    set(handles.message_text,'string','Converged');
    conv=1;
    break;
    end    
  old_vTWv=vTWv;  
  end

if conv == 0
  disp('not converged');
  set(handles.message_text,'string','Not Converged');
  end

% print output to the console

px
py
v

% make a plot

xrange=range(px);
five_pct=0.05*xrange;
xmin=min(px)-five_pct;
xmax=max(px)+five_pct;
yrange=range(py);
five_pct=0.05*yrange;
ymin=min(py)-five_pct;
ymax=max(py)+five_pct;

axis([xmin xmax ymin ymax]);
axis equal;
hold on
    
for i=1:numobs
  obs_str=char(obs_type(i));  
  switch obs_str
    case 'D'
      indx=idtop(pnum,oi(i));
      jndx=idtop(pnum,oj(i));
      plot_dist(px,py,indx,jndx);    
    case 'A'
      indx=idtop(pnum,oi(i));
      jndx=idtop(pnum,oj(i));
      kndx=idtop(pnum,ok(i));
      plot_ang(px,py,indx,jndx,kndx);
    case 'Z'
      indx=idtop(pnum,oi(i));
      jndx=idtop(pnum,oj(i));
      plot_azm(px,py,indx,jndx);
    otherwise
    end
  end

dm=0.03*xrange;
for i=1:numpnt
  j=ptou(i);  
  if j == 0
    plot_cp(px(i),py(i),pnum(i),dm);
  else
    plot_pp(px(i),py(i),pnum(i),dm);
    end
  end

% --------------------------------------------------------------------
function varargout = close_button_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.close_button.
closereq