% az_cond_eqn.m  24-nov-02
% function to evaluate angle condition equation
% and return elements of B-matrix, and F
% args
%  x : array of x-coords of network points
%  y : array of y-coords of network points
%  oi : index of occupied point
%  oj : index of foresight point

%  ob1,ob2,ob3: d,m,s of angle observation

function [b,F]=az_cond_eqn(x,y,oi,oj,ob1,ob2,ob3)
degrad=180/pi;
b=zeros(1,4);
xi=x(oi);
yi=y(oi);
xj=x(oj);
yj=y(oj);

dx=xj-xi;
dy=yj-yi;
d_0=sqrt(dx^2+dy^2);
b(1)=(yj-yi)/d_0^2;
b(2)=-(xj-xi)/d_0^2;
b(3)=-(yj-yi)/d_0^2;
b(4)=(xj-xi)/d_0^2;
aobs=(ob1 + ob2/60.0 + ob3/3600.0)/degrad;
comp_obs=atan2(dx,dy);
if (comp_obs < 0)
  comp_obs=comp_obs +  2*pi;
  end
F=aobs - comp_obs;
