% ang_cond_eqn.m  24-nov-02
% function to evaluate angle condition equation
% and return elements of B-matrix, and F
% args
%  x : array of x-coords of network points
%  y : array of y-coords of network points
%  oi : index of occupied point
%  oj : index of backsight point
%  ok : index of foresight point
%  ob1,ob2,ob3: d,m,s of angle observation

function [b,F]=ang_cond_eqn(x,y,oi,oj,ok,ob1,ob2,ob3)
degrad=180/pi;
b=zeros(1,6);
xi=x(oi);
yi=y(oi);
xj=x(oj);
yj=y(oj);
xk=x(ok);
yk=y(ok);

dxij=xj-xi;
dyij=yj-yi;
dij_0=sqrt(dxij^2+dyij^2);
dxik=xk-xi;
dyik=yk-yi;
dik_0=sqrt(dxik^2+dyik^2);
b(1)=(yk-yi)/dik_0^2 - (yj-yi)/dij_0^2;
b(2)=-(xk-xi)/dik_0^2 + (xj-xi)/dij_0^2;
b(3)=(yj-yi)/dij_0^2;
b(4)=-(xj-xi)/dij_0^2;
b(5)=-(yk-yi)/dik_0^2;
b(6)=(xk-xi)/dik_0^2;
aobs=(ob1 + ob2/60.0 + ob3/3600.0)/degrad;
comp_obs=anglecw(xi,yi,xj,yj,xk,yk);
F=aobs - comp_obs;
