% --------------------------------------------------------------------
function varargout = run_button_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.run_button.

% get sigmas from screen dialogue boxes

set(handles.message_text,'string','                ');
s1=get(handles.edit_dsig,'string');
dsig=str2double(s1);
test=isnan(dsig);
if test == 1
  set(handles.message_text,'string','bad dist sigma');
  break;
else
end

degrad=180/pi;
s1=get(handles.edit_angsig,'string');
sec=str2double(s1);
test=isnan(sec);
if test == 1
  set(handles.message_text,'string','bad angle sigma');
  break;
else
  angsig=(sec/3600)/degrad;
end

s1=get(handles.edit_azsig,'string');
sec=str2double(s1);
test=isnan(sec);
if test == 1
  set(handles.message_text,'string','bad azm sigma');
  break;  
else
  azsig=(sec/3600)/degrad;
end

sig0_sqr=1.0;

% open and read the point file

pfilename=get(handles.edit_pointfile,'string');
[pnum,px,py,cflag]=textread(pfilename,'%f %f %f %f');
[numpnt,n]=size(pnum);

% make index arrays to relate point list and unkown parameter list

ii=0;
for i=1:numpnt
  ptou(i)=0;
  if(cflag(i) ~= 1)
    ii=ii+1;
    ptou(i)=ii;  % point list to unknown list
    utop(ii)=i;  % unknown list to point list
    end
  end
numunkpnt=ii;
numunk=numunkpnt*2;

% open and read the observation file

ofilename=get(handles.edit_obsfile,'string');
[obs_type,oi,oj,ok,ob1,ob2,ob3]=textread(ofilename,'%s %f %f %f %f %f %f');
[numobs,n]=size(obs_type);
r=numobs - numunk;

% fill in the weight matrix

W=zeros(numobs,numobs);
for i=1:numobs
  obs_str=char(obs_type(i));
  switch obs_str
    case 'D'
      W(i,i)=sig0_sqr/dsig^2;
    case 'A'
      W(i,i)=sig0_sqr/angsig^2;
    case 'Z'
      W(i,i)=sig0_sqr/azsig^2;
    otherwise
    end 
  end

old_vTWv=9.999e+06;
for iter=1:10
  iter
  B=zeros(numobs,numunk);
  f=zeros(numobs,1);
  for i=1:numobs
    obs_str=char(obs_type(i));  
    switch obs_str
      case 'D'
        indx=idtop(pnum,oi(i));
        jndx=idtop(pnum,oj(i));
        [b,F]=dis_cond_eqn(px,py,indx,jndx,ob1(i));
        up=ptou(indx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(1);
          B(i,(up-1)*2+2)=b(2);
          end
        up=ptou(jndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(3);
          B(i,(up-1)*2+2)=b(4);
          end
        f(i)=-F;
      case 'A'
        indx=idtop(pnum,oi(i));
        jndx=idtop(pnum,oj(i));
        kndx=idtop(pnum,ok(i));
        [b,F]=ang_cond_eqn(px,py,indx,jndx,kndx,ob1(i),ob2(i),ob3(i));
        up=ptou(indx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(1);
          B(i,(up-1)*2+2)=b(2);
          end
        up=ptou(jndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(3);
          B(i,(up-1)*2+2)=b(4);
          end
        up=ptou(kndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(5);
          B(i,(up-1)*2+2)=b(6);
          end
        f(i)=-F;
      case 'Z'
        indx=idtop(pnum,oi(i));
        jndx=idtop(pnum,oj(i));
        [b,F]=az_cond_eqn(px,py,indx,jndx,ob1(i),ob2(i),ob3(i));
        up=ptou(indx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(1);
          B(i,(up-1)*2+2)=b(2);
          end
        up=ptou(jndx);
        if up ~= 0
          B(i,(up-1)*2+1)=b(3);
          B(i,(up-1)*2+2)=b(4);
          end
      otherwise
      end        
    end

  N=B'*W*B;
  t=B'*W*f;
  del=inv(N)*t
  for i=1:numunkpnt
    np=utop(i);
    px(np)=px(np) + del((i-1)*2+1);
    py(np)=py(np) + del((i-1)*2+2);
    end
  % check for convergence
  
  v=f - B*del;
  vTWv=v'*W*v;
  frac_chg=abs(old_vTWv - vTWv)/vTWv;
  conv=0;
  if frac_chg < 0.0001
    disp('we have converged');
    set(handles.message_text,'string','Converged');
    conv=1;
    break;
    end    
  old_vTWv=vTWv;  
  end

if conv == 0
  disp('not converged');
  set(handles.message_text,'string','Not Converged');
  end

% print output to the console

px
py
v

% make a plot

