% dis_cond_eqn.m  24=nov-02
% function to evaluate distance condition equation
% and return elements of B-matrix, and F
% args
%  x : array of x-coords of network points
%  y : array of y-coords of network points
%  oi : index of first point
%  oj : index of second point
%  o1 : the distance observation

function [b,F]=dis_cond_eqn(x,y,oi,oj,ob1)
b=zeros(1,4);
dobs=ob1;
xi=x(oi);
yi=y(oi);
xj=x(oj);
yj=y(oj);

dx=xj-xi;
dy=yj-yi;
dij_0=sqrt(dx^2+dy^2);
b(1)=(xj-xi)/dij_0;
b(2)=(yj-yi)/dij_0;
b(3)=-(xj-xi)/dij_0;
b(4)=-(yj-yi)/dij_0;
F=dobs - dij_0;

