% ccmeas2.m  18-nov-2012
% image measurement specific for camera calibration with
% iWitness style black dots on white background
% in matlab, browse to folder where the images are located
% thought there was an issue with bias - turned out to be error
% in NOT converting uint8's to double before doing arithmetic
% try the rbbox = rubber band box for this version

s=input('enter image filename: ','s');

% open file for coordinates
[m,n]=size(s);
so=s;
so(n-2)='t';
so(n-1)='x';
so(n)='t';
fid=fopen(so,'at');

fig = figure;
A=imread(s);
image(A);
axis equal

loop_break=0;
while loop_break == 0
  figure(1);
  disp('zoom/pan to next point, then press space bar');
  pause
  s1=input('enter point ID: ','s');
  s=strtrim(s1);
  if(strcmp(s,'quit') == 1)
    close
    fclose(fid);
    return
  else
    disp('make bounding box for target (down - up)');
    figure(1);
    zoom off
    pan off
    k=waitforbuttonpress;
    point1=get(gca,'currentpoint');
    finalrect=rbbox;
    point2=get(gca,'currentpoint');
    point1=point1(1,1:2);
    point2=point2(1,1:2);
    p1=min(point1,point2);
    offset=abs(point1-point2);
    p2=p1+offset;
    px=[p1(1) p2(1) p2(1) p1(1) p1(1)];
    py=[p1(2) p1(2) p2(2) p2(2) p1(2)];
    hold on
    plot(px,py,'k-');
    x1=p1(1);
    y1=p1(2);
    x2=p2(1);
    y2=p2(2);

    % determine centroid and show it
    [x1 y1]
    [x2 y2]
    ix1=round(x1);
    iy1=round(y1);
    ix2=round(x2);
    iy2=round(y2);
    w=ix2-ix1+1;
    h=iy2-iy1+1;
    % img will be a monochrome sub-image, no colors
    img=zeros(h,w);
    for i=1:h
      for j=1:w
        r=iy1-1+i;
        c=ix1-1+j;
        tmp=(double(A(r,c,1))+double(A(r,c,2))+double(A(r,c,3)))/3;
        img(i,j)=255-tmp;
        end
      end
    whi=(img(1,1)+img(h,w)+img(1,w)+img(h,1))/4;
    [img(1,1) img(h,w) img(1,w) img(h,1)]
    hlfh=round(h/2);
    hlfw=round(w/2);
    blk=(img(hlfh,hlfw)+img(hlfh+1,hlfw+1)+img(hlfh,hlfw+1)+img(hlfh+1,hlfw))/4;
    [img(hlfh,hlfw) img(hlfh+1,hlfw+1) img(hlfh,hlfw+1) img(hlfh+1,hlfw)]
    thresh=(whi+blk)/2;
    sumwx=0;
    sumw=0;
    sumwy=0;
    % leave weighting as it was
    %wt=1.0
    for i=1:h
      for j=1:w
        if(img(i,j) > thresh)
          sumwx=sumwx + img(i,j)*j;
          sumwy=sumwy + img(i,j)*i;
          sumw=sumw + img(i,j);
          %sumwx=sumwx + wt*j;
          %sumwy=sumwy + wt*i;
          %sumw=sumw + wt;
          end
        end
      end
    lx=sumwx/sumw;
    ly=sumwy/sumw;
    centroidx=ix1+lx-1;
    centroidy=iy1+ly-1;
    px=[centroidx-7 centroidx+7];
    py=[centroidy-7 centroidy+7];
    plot(px,py,'w-');          
    px=[centroidx-7 centroidx+7];
    py=[centroidy+7 centroidy-7];
    plot(px,py,'w-');  
    s
    [centroidx centroidy]
    %sumwx
    %sumwy
    %sumw
    %whi
    %blk
    %thresh
    %keyboard
    fprintf(fid,'%s %8.1f %8.1f\n',s,centroidx,centroidy);
    end
  end






