% pba_sc.m  11-aug-2010
% photogrammetric bundle adjustment
% for self calibration, added p1,p2 for decentering
% added aux array for image size, new argument to collin function
% add p1,p2 to cam.dat
% use unified LS so we always solve for all parameters
% need 2 more numbers in delta.dat for p1,p2

% update 18-feb-03 add post adjustment statistics and error prop
%                  fix dimension of B
% update 4-mar-05 for version 2, see below
% version 2 supports digital camera/video where we just input pixel
% coords and do interior here, add info to cam.inp file
% please look into residuals to verify they are correct
%
% input data:
% phofiles.dat: names of photo measurement files
% cp.dat: controlpoints
% pho.dat: exposure stations
% cam.dat: camera data
% delta.dat : deltas for numerical partials (see gencof note for order)
% sig.dat: image sigma, pass point object coord. sigma

% parameter ordering
% x0,y0, f,k1,k2,k3,p1,p2
% 01 02 03 04 05 06 07 08
% om1,ph1,kp1,XL1,YL1,ZL1,om2,ph2,kp2,XL2,YL2,ZL2,...
%  09  10  11  12  13  14  15  16  17  18  19  20
% omn,phn,kpn,xln,yln,zln,x1,y1,z1,x2,y2,z2,...,xm,ym,zm
% ............
% full matrices, next version we will be efficient
% gencof returns partials & values:
%  x, y,x0,y0, f,k1,k2,k3,p1,p2, w, p, k,xl,yl,zl, x, y, z, F
% 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20

% read data, count and organize
% transform av + bx = f problem into pseudo v + bx =f problem

% max_iter=1 is useful for debug!

% position tolerance for convergence (in object space)
tol=1.0e-05;
max_iter=20; % for now

[files]=textread('phofiles.dat','%s');
[m,n]=size(files);
tmp_nph=m;

[tmp]=textread('sig.dat','%f');
osig=tmp(1);
ppsig=tmp(2);

[dl]=textread('delta.dat','%f');
[cam,camsig]=textread('cam.dat','%f %f');
niopar=8; % see the first eight entries in the following list

x0=cam(1);
y0=cam(2);
foc=cam(3);
k1=cam(4);
k2=cam(5);
k3=cam(6);
p1=cam(7);
p2=cam(8);
pflag=cam(9);
iw=cam(10);
ih=cam(11);
% pflag: 1=x,y conventional photo coordinates
% pflag: 2=x,y photoshop pixel coordinates, orig upper left x-right, y-down
% pflag: 3=l,s line and sample, reverse order of above
% iw,ih: image width, image height in pixels to derive nominal
%        principal point
% if pflag = 2 or 3, then focal length and any x0,y0 are in pixel units
% x=sample - iw/2;
% y=-(line - ih/2);
% if pflag = 1 then iw,ih are image dimensions in measuring units

cpid={' '};
cpxyz=zeros(2,3);
cpsig=zeros(2,3);
fid=fopen('cp.dat');
have_control=1;
if(fid == -1)
  have_control=0;
  end
% if file not exist then assume control is in
% the photo stations and orientations

if(have_control == 1)
  EOF=feof(fid);
  i=1;
  while (EOF == 0)
    [p]=fscanf(fid,'%s',1);
    blank=isempty(p);
    if (blank == 1)
      break;
      end

    cpid(i)=cellstr(p);
    [c]=fscanf(fid,'%f %f %f',3);
    cpxyz(i,1)=c(1);
    cpxyz(i,2)=c(2);
    cpxyz(i,3)=c(3);
    [s]=fscanf(fid,'%f %f %f',3);
    cpsig(i,1)=s(1);
    cpsig(i,2)=s(2);
    cpsig(i,3)=s(3);
    EOF=feof(fid);
    i=i+1;
    end
  ncp=i-1;
  fclose(fid);

  cpid=cpid';
else
  ncp=0;
  end

phid={' '};
phxyz=zeros(2,3);
phsig=zeros(2,3);
phang=zeros(2,3);
phasg=zeros(2,3);
fid=fopen('pho.dat');
EOF=feof(fid);
i=1;
while (EOF == 0)
  [p]=fscanf(fid,'%s',1);
  blank=isempty(p);
  if (blank == 1)
    break;
    end

  phid(i)=cellstr(p);
  [c]=fscanf(fid,'%f %f %f',3);
  phang(i,1)=c(1);
  phang(i,2)=c(2);
  phang(i,3)=c(3);
  [s]=fscanf(fid,'%f %f %f',3);
  phasg(i,1)=s(1);
  phasg(i,2)=s(2);
  phasg(i,3)=s(3);

  [c]=fscanf(fid,'%f %f %f',3);
  phxyz(i,1)=c(1);
  phxyz(i,2)=c(2);
  phxyz(i,3)=c(3);
  [s]=fscanf(fid,'%f %f %f',3);
  phsig(i,1)=s(1);
  phsig(i,2)=s(2);
  phsig(i,3)=s(3);


  EOF=feof(fid);
  i=i+1;
  end
nph=i-1;
fclose(fid);

phid=phid';

if(tmp_nph ~= nph)
  disp('number photo files different from entries in pho.dat');
  break;
  end

ptid={' ';' '};
ptxyz=zeros(2,3);
ptsig=zeros(2,3);
px=zeros(2,2);
py=zeros(2,2);
nphpt=zeros(2,1);
phpt=zeros(2,2);
npt=0;

% read in the observation data
% note: ndx is logical point number (array index)
%       mdx is logical photo number (array index)

nobs=0;
for i=1:nph
  s=char(files(i));
  [point_id,ox,oy]=textread(s,'%s %f %f');
  [m,n]=size(s);
  if (n < 5)
    disp('photo name too short');
    return
  else
    ss=s(1:n-4);
    % remove the ".dat" from photo-id
    end
  mdx=gndx(phid,ss);
  if (mdx == 0)
    disp('photo id from filename not in list');
    return
    end
  [m,n]=size(point_id);
  for j=1:m
    s1=char(point_id(j));
    ndx=gndx(ptid,s1);
    if (ndx == 0)
      npt=npt+1;
      ptid(npt)=cellstr(s1);
      switch pflag
        case 1
          px(npt,1)=ox(j);
          py(npt,1)=oy(j);
        case 2
          px(npt,1)=ox(j)-iw/2;
          py(npt,1)= -(oy(j)-ih/2);
        case 3
          px(npt,1)=oy(j)-iw/2;
          py(npt,1)= -(ox(j)-ih/2);
        otherwise
        end
      nphpt(npt)=1;
      phpt(npt,1)=mdx;
    else
      nphpt(ndx)=nphpt(ndx)+1;
      switch pflag
        case 1
          px(ndx,nphpt(ndx))=ox(j);
          py(ndx,nphpt(ndx))=oy(j);
        case 2
          px(ndx,nphpt(ndx))=ox(j)-iw/2;
          py(ndx,nphpt(ndx))= -(oy(j)-ih/2);
        case 3
          px(ndx,nphpt(ndx))=oy(j)-iw/2;
          py(ndx,nphpt(ndx))= -(ox(j)-ih/2);
        otherwise
        end
      phpt(ndx,nphpt(ndx))=mdx;
      end
    nobs=nobs + 2;
    end
  end

% check to make sure that each point is seen on two photos
% not strictly necessary if cp but do not allow that at present

for i=1:npt
  if (nphpt(i) < 2)
    disp('we have point on only one photo');
    disp_str=char(ptid(i));
    disp('point id is:');
    disp(disp_str);
    jndx=phpt(i,1);
    disp_str=char(phid(jndx));
    disp('on photo:');
    disp(disp_str);
%   i
%   ptid
%   nphpt
%   phpt
    return
    end
  end

% ok let's flag the points as control 1=yes, 0=no
% if yes, then transfer the xyz & sigma

for i=1:npt
  s1=char(ptid(i));
  ndx=gndx(cpid,s1);

  ptconflg(i)=0;
  if (ndx ~= 0)
    ptconflg(i)=1;
    ptxyz(i,:)=cpxyz(ndx,:);
    ptsig(i,:)=cpsig(ndx,:);
    end
  end

% compute ground point approximations for pass points
% try taka's linear method, use int_leq2.m for terrestrial case

for i=1:npt
   if(ptconflg(i) == 0)
    %disp('intersecting for pass point');
    %pause
    B=zeros(2*nphpt(i),3);
    f=zeros(2*nphpt(i),1);
    ndx=1;
    for j=1:nphpt(i)
      k=phpt(i,j);
      x=px(i,j);
      y=py(i,j);
      [mtx,vec]=int_leq2(x,y,phxyz(k,:),phang(k,:),cam);
      B(ndx:ndx+1,:)=mtx;
      f(ndx:ndx+1)=vec;
      ndx=ndx+2;
      end
    N=B'*B;
    t=B'*f;
    del=inv(N)*t;
    ptxyz(i,:)=del';
    ptsig(i,:)=[ppsig ppsig ppsig];
    end
  end

% make the original and current parameter vectors for the rhs "fx" term

nrowB=2*nobs;
ncolB=niopar + nph*6 + npt*3;
opvec=zeros(ncolB,1);
for i=1:niopar
  opvec(i)=cam(i);
  end
ndx=niopar+1;
for i=1:nph
  opvec(ndx:ndx+2)=phang(i,1:3);
  ndx=ndx+3;
  opvec(ndx:ndx+2)=phxyz(i,1:3);
  ndx=ndx+3;
  end
for i=1:npt
  opvec(ndx:ndx+2)=ptxyz(i,1:3);
  ndx=ndx+3;
  end
cpvec=opvec;

% observation sigmas
% we assume that a priori sig-nought-sqr = 1.0

Q=[osig^2 0; 0 osig^2];
W=inv(Q);
Qe=zeros(2,2);
We=zeros(2,2);
T=zeros(2,2);

% make iteration loop

iter=1;
cont=1;
while (cont == 1)
  B=zeros(nrowB,ncolB);
  f=zeros(nrowB,1);
  A=zeros(2,2);

% cycle through all observations and build B,A,f,We

  rdx=1;
  for i=1:npt
    for j=1:nphpt(i)
      k=phpt(i,j);
      x=px(i,j);
      y=py(i,j);
      b=gencof(x,y,phang(k,:),phxyz(k,:),ptxyz(i,:),cam,dl);
      %disp('first misclosure')
      %x
      %y
      %i j k]
      %phang(k,:)
      %phxyz(k,:)
      %ptxyz(i,:)
      %cam
      %pause
      A=b(:,1:2);
      Qe=A*Q*A';
      We=inv(Qe);
      % cholesky decomposition to incorporate We into B,f
      % We = | m11 m12 | = | t1  0 | * | t1 t2 |
      %      | m21 m22 |   | t2 t3 |   |  0 t3 |
      t1=sqrt(We(1,1));
      t2=We(1,2)/t1;
      t3=sqrt(We(2,2) - t2^2);
      T=[t1 t2; 0 t3];
      bb=T*b;
      % niopar=8 currently
      B(rdx:rdx+1,1:niopar)=bb(:,3:10);
      cdx=niopar + (k-1)*6 + 1;
      B(rdx:rdx+1,cdx:cdx+5)=bb(:,11:16);
      cdx=niopar + nph*6 + (i-1)*3 + 1;
      B(rdx:rdx+1,cdx:cdx+2)=bb(:,17:19);
      f(rdx:rdx+1)=-bb(:,20);
      %[i j]
      %[bb(1,20) bb(2,20)]
      %pause
      rdx=rdx+2;
      end
    end

% solve, add corrections, and repeat

  N=B'*B;
  t=B'*f;
  pre_condN=cond(N);

% ok compute the free-net (inner) constraint matrix and try outside
% comment out the code but leave it here for later experiments

%  C=zeros(7,131);
%  Z=zeros(7,7);
%  for i=1:nph
%    ndx=12 + (i-1)*6;
%    X=phxyz(i,1);
%    Y=phxyz(i,2);
%    Z=phxyz(i,3);
%    C(:,ndx:ndx+2)=[1 0 0;
%                    0 1 0;
%                    0 0 1;
%                    0 Z -Y;
%                    -Z 0 X;
%                    Y -X 0;
%                    X Y Z];
%    end
%  for i=1:npt
%    ndx=9 + nph*6 + (i-1)*3;
%    X=ptxyz(i,1);
%    Y=ptxyz(i,2);
%    Z=ptxyz(i,3);
%    C(:,ndx:ndx+2)=[1 0 0;
%                    0 1 0;
%                    0 0 1;
%                    0 Z -Y;
%                    -Z 0 X;
%                    Y -X 0;
%                    X Y Z];
%    end
%
%  keyboard

% generate the unified LS weight contributions

  Wxx=zeros(ncolB,1);
  for i=1:niopar
    Wxx(i)=1/camsig(i)^2;
    end
  for i=1:nph
    ndx=niopar + (i-1)*6 + 1;
    Wxx(ndx)  =1/phasg(i,1)^2;
    Wxx(ndx+1)=1/phasg(i,2)^2;
    Wxx(ndx+2)=1/phasg(i,3)^2;
    Wxx(ndx+3)=1/phsig(i,1)^2;
    Wxx(ndx+4)=1/phsig(i,2)^2;
    Wxx(ndx+5)=1/phsig(i,3)^2;
    end
  for i=1:npt
    ndx=niopar + nph*6 + (i-1)*3 + 1;
    Wxx(ndx)  =1/ptsig(i,1)^2;
    Wxx(ndx+1)=1/ptsig(i,2)^2;
    Wxx(ndx+2)=1/ptsig(i,3)^2;
    end

% add in the unified weights

  fx=cpvec - opvec;
  for i=1:ncolB
    N(i,i)=N(i,i) + Wxx(i);
    t(i)=t(i) - Wxx(i)*fx(i);
    end

  delxyz=[0 0 0];
  countxyz=0;
  condN=cond(N);
  del=inv(N)*t;
  cpvec=cpvec + del;
  % note keeping two copies of the current params
  all_small=1;
  for i=1:niopar
    cam(i)=cam(i) + del(i);
    end;
  ndx=niopar+1;
  for i=1:nph
  countxyz=countxyz+1;
    for j=1:3
      phang(i,j)=phang(i,j) + del(ndx);
      ndx=ndx+1;
      end
    for j=1:3
      phxyz(i,j)=phxyz(i,j) + del(ndx);
      delxyz(j)=delxyz(j) + abs(del(ndx));
      if(abs(del(ndx)) > tol)
        all_small=0;
        end
      ndx=ndx+1;
      end
    end
  for i=1:npt
    countxyz=countxyz+1;
    for j=1:3
      ptxyz(i,j)=ptxyz(i,j) + del(ndx);
      delxyz(j)=delxyz(j) + del(ndx);
      if(abs(del(ndx)) > tol)
        all_small=0;
        end
      ndx=ndx+1;
      end
    end

  delxyz=delxyz/countxyz;
  [ss,serr]=sprintf('iter %3d position corrections: %10f %10f %10f',iter,delxyz);
  disp(ss);
  if (all_small == 1)
    cont=0;
    disp('we have converged');
    end

  iter=iter+1;
  if iter > max_iter
    cont=0;
    end
  end

if(all_small == 0)
  disp('we did not converge');
  end

% compute and print residuals (by photo)

[ss,serr]=sprintf('\nobservation residuals');
disp(ss);
BB=zeros(2,ncolB);
ff=zeros(2,1);

vtWv=0.0;
rmsx=0.0;
rmsy=0.0;
for i=1:nph
  s1=char(phid(i));
  [ss,serr]=sprintf('\nphoto %s \n',s1);
  disp(ss);
  for j=1:npt
    for k=1:nphpt(j)
      if (phpt(j,k) == i)
        % ok now compute residuals point j, photo i
        x=px(j,k);
        y=py(j,k);
        b=gencof(x,y,phang(i,:),phxyz(i,:),ptxyz(j,:),cam,dl);
        A=b(:,1:2);
        Qe=A*Q*A';
        We=inv(Qe);
        % cholesky decomposition to incorporate We into B,f
        % We = | m11 m12 | = | t1  0 | * | t1 t2 |
        %      | m21 m22 |   | t2 t3 |   |  0 t3 |
        % t1=sqrt(We(1,1));
        % t2=We(1,2)/t1;
        % t3=sqrt(We(2,2) - t2^2);
        % T=[t1 t2; 0 t3];
        % bb=T*b;
        bb=b;
        BB(1:2,1:niopar)=bb(:,3:10);
        cdx=niopar + (k-1)*6 + 1;
        BB(1:2,cdx:cdx+5)=bb(:,11:16);
        % following index calc different than similar code above
        % it was wrong here: i should be j
        cdx=niopar + nph*6 + (j-1)*3 + 1;
        BB(1:2,cdx:cdx+2)=bb(:,17:19);
        ff(1:2)=-bb(:,20);
        %size(Q)
        %size(A)
        %size(We)
        %size(ff)
        %size(BB)
        %size(del)
        %keyboard
        v=Q*A'*We*(ff-BB*del);
        vtWv=vtWv + v'*W*v;
        rmsx=rmsx + v(1)^2;
        rmsy=rmsy + v(2)^2;
        s1=char(ptid(j));
        [ss,serr]=sprintf('%10s %10.3f %10.3f',s1,v);
        disp(ss);
        end
      end
    end
  end

% look at post-adjustment statistics and error prop
% use common assumptions - may need to modify for unusual cases

rms=sqrt((rmsx+rmsy)/nobs);
rmsx=sqrt(rmsx/(nobs/2));
rmsy=sqrt(rmsy/(nobs/2));
nunk=(npt-ncp)*3 + nph*6;
redun=nobs-nunk;
sign2hat=vtWv/redun;
signhat=sqrt(sign2hat);
aprioris2=osig^2;
aprioris=osig;

[ss,serr]=sprintf('\npost adjustment statistics & error propagation\n');
disp(ss);
[ss,serr]=sprintf('%s %10.3f %10.3f','rms-x,rms-y = ',rmsx,rmsy);
disp(ss);
[ss,serr]=sprintf('%s %12.6f','total coord rms = ',rms);
disp(ss);
[ss,serr]=sprintf('%s %6d','number of points = ',npt);
disp(ss);
[ss,serr]=sprintf('%s %6d','number of control points = ',ncp);
disp(ss);
[ss,serr]=sprintf('%s %6d','number of observations = ',nobs);
disp(ss);
[ss,serr]=sprintf('%s %6d','number of photos = ',nph);
disp(ss);
[ss,serr]=sprintf('%s %6d','redundancy = ',redun);
disp(ss);
[ss,serr]=sprintf('%s %8.2f','post-adj sigma-nought squared = ',sign2hat);
disp(ss);

% print photo data

[ss,serr]=sprintf('\nexterior orientation data for photos');
disp(ss);
for i=1:nph
  s1=char(phid(i));
  [ss,serr]=sprintf('\nphoto %s\n',s1);
  disp(ss);
  [ss,serr]=sprintf('w,p,k %12f %12f %12f',phang(i,:));
  disp(ss);
  [ss,serr]=sprintf('x,y,z %12.3f %12.3f %12.3f',phxyz(i,:));
  disp(ss);
  end

% print point data
[ss,serr]=sprintf('\npoint coordinates\n');
disp(ss);
for i=1:npt
  s1=char(ptid(i));
  [ss,serr]=sprintf('%10s %12.3f %12.3f %12.3f',s1,ptxyz(i,:));
  disp(ss);
  end

% print camera data
[ss,serr]=sprintf('\nrefined camera parameters\n');
disp(ss);
[ss,serr]=sprintf('%s %12.3f','x0',cam(1));
disp(ss);
[ss,serr]=sprintf('%s %12.3f','y0',cam(2));
disp(ss);
[ss,serr]=sprintf('%s %12.3f','foc',cam(3));
disp(ss);
[ss,serr]=sprintf('%s %12.8g','k1',cam(4));
disp(ss);
[ss,serr]=sprintf('%s %12.8g','k2',cam(5));
disp(ss);
[ss,serr]=sprintf('%s %12.8g','k3',cam(6));
disp(ss);
[ss,serr]=sprintf('%s %12.8g','p1',cam(7));
disp(ss);
[ss,serr]=sprintf('%s %12.8g','p2',cam(8));
disp(ss);
[ss,serr]=sprintf('%s %14.8g','cond(N) before Wts',pre_condN);
disp(ss);
[ss,serr]=sprintf('%s %14.8g','cond(N) after Wts',condN);
disp(ss);
[ss,serr]=sprintf('\n\n');
disp(ss);
  
% print discrepancies at control points

% do iteratively reweighted ls or maybe L1

% maybe do residual plots in image space

% maybe do control plots in object, xy space

% resurrect chris oneil's data for gps-photo ??


