% gencof.m  2-jan-03
% generate coefficients of collinearity equations
% for bundle program, by numerical approximation
% result b is 2 x 20 matrix with the following elements
%
% | dFx/dx dFx/dy dFx/dx0 dFx/dy0 dFx/df dFx/dk1 dFx/dk2 dFx/dk3 dFx/dp1 dFx/dp2
% | dFy/dx dFy/dy dFy/dx0 dFy/dy0 dFy/df dFy/dk1 dFy/dk2 dFy/dk3 dFy/dp1 dFy/dp2
%
% dFx/dw dFx/dp dFx/dk dFx/dXL dFx/dYL dFx/dZL
% dFy/dw dFy/dp dFy/dk dFy/dXL dFy/dYL dFy/dZL
%
% dFx/dX dFx/dY dFx/dZ Fx |
% dFy/dX dFy/dY dFy/dZ Fy |
%

function b=gencof(x,y,phang,phxyz,ptxyz,cam,dl)
p=zeros(20,1);
b=zeros(2,20);
p(1)=x;
p(2)=y;
ndx=3;
for i=1:8
  p(ndx)=cam(i);
  ndx=ndx+1;
  end
for i=1:3
  p(ndx)=phang(i);
  ndx=ndx+1;
  end
for i=1:3
  p(ndx)=phxyz(i);
  ndx=ndx+1;
  end
for i=1:3
  p(ndx)=ptxyz(i);
  ndx=ndx+1;
  end
ncol=cam(10);
nrow=cam(11);
maxr=sqrt((nrow/2)^2 + (ncol/2)^2);
p(ndx)=maxr;

F=collin(p);
for i=1:19
  pwk=p;
  pwk(i)=p(i)+dl(i);
  Fp=collin(pwk);
  dFxdp=(Fp(1)-F(1))/dl(i);
  dFydp=(Fp(2)-F(2))/dl(i);
  b(1,i)=dFxdp;
  b(2,i)=dFydp;
  end
b(1,20)=F(1);
b(2,20)=F(2);

