% bld_geom2.m  26-april-2013
% define polygon vertices and build geometry
% for quad face enter 4 vertices and material code
% for triangle face enter 3 vertices, then 'none' for 4th vertex, then material code

[v1,v2,v3,v4,mtl]=textread('quads.txt','%s %s %s %s %s');
[m,n]=size(v1);
npoly=m;
[point_id,x,y,z]=textread('point_list.txt','%s %f %f %f');
[m,n]=size(x);
npt=m;
figure(1);
hold on

for i=1:npoly
  X=zeros(4,1);
  Y=zeros(4,1);
  Z=zeros(4,1);
  Xt=zeros(3,1);
  Yt=zeros(3,1);
  Zt=zeros(3,1);
  % first vertex
  s1=char(v1(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(1)=z(j);
      Y(1)=x(j);
      Z(1)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end
  % second vertex
  s1=char(v2(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(2)=z(j);
      Y(2)=x(j);
      Z(2)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end
  % third vertex
  s1=char(v3(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(3)=z(j);
      Y(3)=x(j);
      Z(3)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end

  % fourth vertex
  have_tri=0;
  if(strcmp(v4(i),'none') ~= 1)
    %disp('quad');
    s1=char(v4(i));
    found=0;
    for j=1:npt
      s2=char(point_id(j));
      t=strcmp(s1,s2);
      if(t==1)
        found=1;
        X(4)=z(j);
        Y(4)=x(j);
        Z(4)=y(j);
        end
      end
    if(found==0)
      disp('could not find vertex');
      s1
      pause
      end  
  else
    have_tri=1;
    %disp('tri');
    for j=1:3
      Xt(j)=X(j);
      Yt(j)=Y(j);
      Zt(j)=Z(j);
      end
    end


%  i
%  v1(i)
%  v2(i)
%  v3(i)
%  v4(i)
%  X
%  Y
%  Z
%  pause

  % get color from material
  s1=char(mtl(i));
  cl=[0 0 1];
  t=strcmp(s1,'paper');
  if(t==1)
    cl=[0.95 0.95 0.95];
    end
  t=strcmp(s1,'wood');
  if(t==1)
    cl=[0.84 0.7 0];
    end
  t=strcmp(s1,'wood_2');
  if(t==1)
    cl=[0.7 0.4 0.4];
    end
  t=strcmp(s1,'steel');
  if(t==1)
    cl=[0.2 0.5 0.6];
    end
  if(have_tri == 1)
    patch(Xt,Yt,Zt,cl);
  else
    patch(X,Y,Z,cl);
    end
  end

axis equal
camproj('orthographic');
view(90,0);
