% bld_geom.m  12-april-2012
% define polygon vertices and build geometry

[v1,v2,v3,v4,mtl]=textread('quads.txt','%s %s %s %s %s');
[m,n]=size(v1);
npoly=m;
[point_id,x,y,z]=textread('point_list.txt','%s %f %f %f');
[m,n]=size(x);
npt=m;
figure(1);
hold on

for i=1:npoly
  X=zeros(4,1);
  Y=zeros(4,1);
  Z=zeros(4,1);
  % first vertex
  s1=char(v1(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(1)=z(j);
      Y(1)=x(j);
      Z(1)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end
  % second vertex
  s1=char(v2(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(2)=z(j);
      Y(2)=x(j);
      Z(2)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end
  % third vertex
  s1=char(v3(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(3)=z(j);
      Y(3)=x(j);
      Z(3)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end
  % fourth vertex
  s1=char(v4(i));
  found=0;
  for j=1:npt
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
      found=1;
      X(4)=z(j);
      Y(4)=x(j);
      Z(4)=y(j);
      end
    end
  if(found==0)
    disp('could not find vertex');
    s1
    pause
    end  

%  i
%  v1(i)
%  v2(i)
%  v3(i)
%  v4(i)
%  X
%  Y
%  Z
%  pause

  % get color from material
  s1=char(mtl(i));
  cl=[0 0 1];
  t=strcmp(s1,'wall');
  if(t==1)
    cl=[1 0 0];
    end
  t=strcmp(s1,'roof');
  if(t==1)
    cl=[0.7 0.3 0.3];
    end
  t=strcmp(s1,'stone');
  if(t==1)
    cl=[0.7 0.7 0.7];
    end
  t=strcmp(s1,'glass');
  if(t==1)
    cl=[0.3 0.3 0.3];
    end
  patch(X,Y,Z,cl);
  end

axis equal
camproj('orthographic');
view(90,0);
