% get_plane.m  29-dec-2012
% get plane parameters from first three CPs

function [AA,BB,CC,DD,Xprime,Yprime,Zprime,M,T] = get_plane(Xin,Yin,Zin)

% get equation of plane from determinant

x1=Xin(1);
y1=Yin(1);
z1=Zin(1);
x2=Xin(2);
y2=Yin(2);
z2=Zin(2);
x3=Xin(3);
y3=Yin(3);
z3=Zin(3);
AA=(y2*z3-y3*z2) - (y1*z3-y3*z1) + (y1*z2-y2*z1);
BB=-( (x2*z3-x3*z2) - (x1*z3-x3*z1) + (x1*z2-x2*z1) );
CC=(x2*y3-x3*y2) - (x1*y3-x3*y1) + (x1*y2-x2*y1);
DD=-( z1*(x2*y3-x3*y2) - z2*(x1*y3-x3*y1) + z3*(x1*y2-x2*y1) );

% make sure normal vector points toward the camera

v1=[x3-x1;y3-y1;z3-z1];
v2=[x2-x1;y2-y1;z2-z1];
v3=cross(v1,v2);

%v1
%v2
%v3
%pause

%AA
%BB
%CC
%DD
%pause

dp=dot([AA;BB;CC],v3);
if(dp < 0)
  AA=-AA;
  BB=-BB;
  CC=-CC;
  DD=-DD;
  end

%AA
%BB
%CC
%DD
%pause

xp=[x3-x1;y3-y1;z3-z1];
xp=xp/sqrt(xp' * xp); %normalize
zp=[AA;BB;CC];
zp=zp/sqrt(zp' * zp); %normalize
yp=cross(zp,xp);
yp=yp/sqrt(yp' * yp); %normalize

% rows of the rotation matrix are components in the "from" system,
% of unit basis vectors in the "to" system

M=[xp(1) xp(2) xp(3);
   yp(1) yp(2) yp(3);
   zp(1) zp(2) zp(3)];
% this matrix takes x,y,z to xp,yp,zp

%M
%pause

% preliminary transform all points, compute shifts so all positive

[npts,ndum]=size(Xin);
minx=9.9e+09;
miny=9.9e+09;
minz=9.9e+09;
for i=1:npts
  out=M*[Xin(i);Yin(i);Zin(i)];
  if(out(1) < minx)
     minx=out(1);
     end
  if(out(2) < miny)
    miny=out(2);
    end
  if(out(3) < minz)
    minz=out(3);
    end
  end

Tx=10;
if(minx < 0)
  Tx=abs(minx) + 10;
  end
Ty=10;
if(miny < 0)
  Ty=abs(miny) + 10;
  end
Tz=10;
if(minz < 0)
  Tz=abs(minz) + 10;
  end
T=[Tx;Ty;Tz];
Xprime=zeros(npts,1);
Yprime=zeros(npts,1);
Zprime=zeros(npts,1);
for i=1:npts
  out=M*[Xin(i);Yin(i);Zin(i)] + T;
  Xprime(i)=out(1);
  Yprime(i)=out(2);
  Zprime(i)=out(3);
  end
