% apx_eo2.m  29-dec-2012
% originally called par8_extr_eo6.m
% major revision for improved flexibility and functionality
% now allow object points to be in any (planar) orientation, not just on XY-plane
% note: there is a par8_extr_eo5.m in d:\classes\photo1_12\rbverz\ which formats the
% output data directly for bundle program input - incorporate that here.

% revise because getting complex numbers for EO for some photos
% force computed sin of angle to be in range -1 to +1, was slightly out of range
% for 1 case
%
% revise for reading bundle measure file with alpha ID and computing approx
% fix some errors, see black notebook for details
% solve 8-parameter problem, then
% extract physical parameters a,e,d,ap,ep,dp,hp,fp
% then either with knowledge of f, solve for t,XL,YL,ZL,w,p,k
% or with knowledge of location of principal point,
% solve for isocenter location, t, f, XL,YL,ZL,w,p,k
% change meas input asumption to x,y not l,s
% forget the Xref,Yref,Zref for now while debug
% note: derivation goes from u',v' -> u,v
% ok big screw-up my a0,a1,a2,b0,b1,b2,c1,c2 notation is NOT THE SAME AS
% emm notation of a1,b1,c1,a2,b2,c2,a0,b0
% JB notation
% modify to allow pflag=1: x,y conventional
%                 pflag=2: x,y photoshop
%                 pflag=3  l,s
% ppnt.dat should have principal point coordinates in the order given by pflag
% and with the direction consistent with pflag
%                 pflag=1: pp in conventional x,y system
%                 pflag=2: pp in photoshop x,y system
%                 pflag=3: pp in l,s system
% for now hardwire pflag in program - future, read it in
%
%     a0 + a1*x + a2*y
% X = ---------------------
%     c1*x + c2*t +  1
%
%     b0 + b1*x + b2*y
% Y = --------------------
%     c1*x + c2*y + 1
%
% X=[x y 1 0 0 0 -Xx -Xy] [  a0 ]
% Y=[0 0 0 x y 1 -Yx -Yy] [  a1 ]
%                         [  a2 ]
%                         [  b0 ]
%                         [  b1 ]
%                         [  b2 ]
%                         [  c1 ]
%                         [  c2 ]
% EM notation
%
%     a1*up + b1*vp + c1
% U = ---------------------
%     a0*up + b0*vp +  1
%
%     a2*up + b2*vp + c2
% V = --------------------
%     a0*up + b0*vp +  1
%
% U=[up vp 1  0  0 0 -U*up -U*vp] [  a0 ]
% V=[ 0  0 0 up vp 1 -V*up -V*vp] [  a1 ]
%                                 [  a2 ]
%                                 [  b0 ]
%                                 [  b1 ]
%                                 [  b2 ]
%                                 [  c1 ]
%                                 [  c2 ]
% 
% 
pflag=2;
%pflag=1;

degrad=180/pi;
fs=input('enter image measurement file name: ','s');
[point_id,o1,o2]=textread(fs,'%s %f %f');
[contr_id,Xin,Yin,Zin]=textread('rect.txt','%s %f %f %f');
load ca.txt
ppnt=zeros(2);
if(pflag==1)
  ppnt(1)=ca(1);
  ppnt(2)=ca(2);
  end
if(pflag==2)
  ppnt(1)=ca(1)/2; % width/2
  ppnt(2)=ca(2)/2; % height/2
  end
foc=ca(3);

[m,n]=size(Xin);
ncp=m;
npts=ncp;
if(m < 4)
  disp('need at least 4 (2D) control points in rect.txt');
  return
  end


% force all of the CPs to be found in the measurements
[m,n]=size(o1);
nmea=m;
mea2d=zeros(ncp,2);
% extract just the points that are needed
for i=1:ncp
  found=0;
  s1=char(contr_id(i));
  for j=1:nmea
    s2=char(point_id(j));
    t=strcmp(s1,s2);
    if(t==1)
       mea2d(i,:)=[o1(j) o2(j)];
       found=1;
       end
    end
  if(found == 0)
    disp('could not find the following point in measurements');
    s1
    pause
    return
    end
  end

% ok, some big changes are here - determine plane from first 3 CPs, project CPs into this plane
% which will be XY plane with Z toward the camera, let's agree that points will be CW order
% when looking from camera, and first three not collinear
% after done with extraction of w,p,k,XL,YL,ZL then transform back to original coordinate system
% at the end

[AA,BB,CC,DD,Xprime,Yprime,Zprime,MM,TT]=get_plane(Xin,Yin,Zin);
Xin0=Xin;
Yin0=Yin;
Zin0=Zin;
Xin=Xprime;
Yin=Yprime;
Zin=Zprime;
%disp('transformed control');
%[Xin Yin Zin]
%pause

Xref=Xin(1);
Yref=Yin(1);
Zterrain=Zin(1);

% shift in x&y only for now

B=zeros(2*npts,8);
f=zeros(2*npts,1);

% we fiddle with measurement system coordinates so that the final
% image coordinates used in the 8-par have origin at pp, x to the
% right and y up

for i=1:npts
  % shift obj XY to local origin
  X=Xin(i) - Xref;
  Y=Yin(i) - Yref;
  crd1=mea2d(i,1);
  crd2=mea2d(i,2);
  switch pflag
    case 1
      x=crd1 - ppnt(1);
      y=crd2 - ppnt(2);
    case 2
      x=crd1 - ppnt(1);
      y= -(crd2 - ppnt(2));
    case 3
      x=crd2 - ppnt(2);
      y= -(crd1 - ppnt(1));
    otherwise
    end

  %i
  %ss=char(contr_id(i));
  %ss
  %[X Y x y]
  %pause    

  ii=(2*i)-1;
  B(ii  ,:)=[x y 1 0 0 0 -X*x -X*y];
  B(ii+1,:)=[0 0 0 x y 1 -Y*x -Y*y];
  f(ii  )=X;
  f(ii+1)=Y;
  end

del=inv(B'*B)*B'*f;
del
% use emm a's, and b's, and c's
a1=del(1);
b1=del(2);
c1=del(3);
a2=del(4);
b2=del(5);
c2=del(6);
a0=del(7);
b0=del(8);
resid=f - B*del;
disp('residuals: vx vy');
rmsx=0;
rmsy=0;
for i=1:npts
  xidx=(i*2)-1;
  yidx=xidx+1;
  vx=resid(xidx);
  vy=resid(yidx);
  rmsx=rmsx + vx*vx;
  rmsy=rmsy + vy*vy;
  fprintf(1,'%5f %10.2f %10.2f\n',i,vx,vy);
  end

rmsx=sqrt(rmsx/npts);
rmsy=sqrt(rmsy/npts);
disp('line and sample rms');
[rmsx rmsy]

% ok now we have 8 parameters: a0,a1,a2,b0,b1,b2,c1,c2
% ok now recover physical parameters alpha,d,e,alpha-prime,d-prime,e-prime,h-prime,fprime

fp_minus_dp=1/sqrt(a0^2+b0^2)
alpha_prime=atan2(-b0,-a0)
alphp=alpha_prime;
a1p=a1*fp_minus_dp;
b1p=b1*fp_minus_dp;
a2p=a2*fp_minus_dp;
b2p=b2*fp_minus_dp;
% make a change here
Mx=[-cos(alpha_prime) sin(alpha_prime); -sin(alpha_prime) -cos(alpha_prime)];
vc=[a1p-b2p; b1p+a2p];
d_and_e=inv(Mx)*vc;
d=d_and_e(1)
e=d_and_e(2)
term1=a1p+d*cos(alpha_prime);
term2=b1p+d*sin(alpha_prime);
h_prime=sqrt(term1^2 + term2^2)
hp=h_prime;
comp_alph=atan2(b1p+d*sin(alpha_prime),a1p+d*cos(alpha_prime)) - alpha_prime
alph=comp_alph;
Mx=[cos(alph) sin(alph); -sin(alph) cos(alph)];
vc=[(c1-d)*fp_minus_dp/h_prime;(c2-e)*fp_minus_dp/h_prime];
dp_and_ep=inv(Mx)*vc;
dp=dp_and_ep(1)
ep=dp_and_ep(2)
f_prime=fp_minus_dp + dp
fp=f_prime

%chka0=-cos(alpha_prime)/fp_minus_dp;
%a0
%chkb0=-sin(alpha_prime)/fp_minus_dp;
%b0




% ok we now have extracted all 8 physical parameters from the
% 8 polynomial coefficients

assumption=1; % have f
% get it from ca.txt file
% units = pixels for jb canon xt
% foc=4440.785;

% assumption=2; % know principal point

if(assumption == 1)
  quot=foc/fp;
  % force sin of t to be in range -1 to +1
  if(quot > 1.0)
    quot=1.0;
    end
  if(quot < -1.0)
    quot= -1.0;
    end
  t=asin(quot)
  h=hp*sin(t)
  %pause
  end

if(assumption == 2)
  % next get coords of isocenter in the measuring system (u',v')
  Mx=[cos(alphp) sin(alphp); -sin(alphp) cos(alphp)];
  vc=[-dp;-ep];
  isoctr=inv(Mx)*vc
  oi=norm(isoctr,2)
  % ok now solve "(oi/fp) = sin(t)*tan(t/2)" for t
  % seems there is a symbolic solution
  c=oi/fp;
  t=asin(c-1) + pi/2
  foc=fp*sin(t)
  h=hp*sin(t)
  end

ZL=h + Zterrain;
Mx=[cos(alph) sin(alph); -sin(alph) cos(alph)];
%vc=[-d;-e];
%Isoctr=inv(Mx)*vc
NI=h*tan(t/2);
vc=[-NI;0];
Nadir_uv=Mx*vc + [d;e];
XL=Nadir_uv(1) + Xref;
YL=Nadir_uv(2) + Yref;
%XL=d + Xref;
%YL=e + Yref;
M1=[cos(alph) -sin(alph) 0;sin(alph) cos(alph) 0; 0 0 1];
M2=[cos(-t) 0 -sin(-t); 0 1 0; sin(-t) 0 cos(-t)];
M3=[cos(alphp) -sin(alphp) 0;sin(alphp) cos(alphp) 0; 0 0 1];
M=M3*M2*M1;
% now extract omega, phi, kappa
%     |  cos(p)*cos(k)   --------------     ------------- |
% m = | -cos(p)*sin(k)   --------------     ------------- |
%     |  sin(p)          -sin(w)*cos(p)     cos(w)*cos(p) |
phi_local=asin(M(3,1)); % note: two choices here
omega_local=atan2(-M(3,2)/cos(phi_local),M(3,3)/cos(phi_local));
kappa_local=atan2(-M(2,1)/cos(phi_local),M(1,1)/cos(phi_local));
XL;
YL;
ZL;
%disp('prior 6 numbers = local eo');
%pause




% transform from the local plane system to the original reference system
% careful here - if m31 is near +/- 1 (phi near +/- 90) this will give problems
% you could extract quaternion to avoid problem.
thresh=0.005;
Morg=M*MM;
if( ((1.0-Morg(3,1)) < thresh) || ((Morg(3,1)+1.0) < thresh) )
  disp('near phi +/- 90, extracting omega & kappa unstable');
  disp('press any key to continue');
  pause
  end

phi=asin(Morg(3,1)); % note: two choices here
omega=atan2(-Morg(3,2)/cos(phi),Morg(3,3)/cos(phi));
kappa=atan2(-Morg(2,1)/cos(phi),Morg(1,1)/cos(phi));
LL=MM'*([XL;YL;ZL] - TT);
XL=LL(1);
YL=LL(2);
ZL=LL(3);

XL
YL
ZL
omega
phi
kappa

% write out approx. file in format for bundle program

% truncate the file extension for photo ID
id_string=fs;
[m,n]=size(id_string);
found_period=0;
for i=1:n
  if(id_string(i) == '.')
    found_period=1;
    pos=i;
    end
  end
if(found_period == 1)
  for i=pos:n
    id_string(pos)=[];
    end
  end

big=1.0e+08;
fid=fopen('pho.dat','at');
fprintf(fid,'%s\n',id_string);
fprintf(fid,'%12.7f %12.7f %12.7f\n',omega,phi,kappa);
fprintf(fid,'%12.2e %12.2e %12.2e\n',big,big,big);
fprintf(fid,'%12.3f %12.3f %12.3f\n',XL,YL,ZL);
fprintf(fid,'%12.2e %12.2e %12.2e\n',big,big,big);
fclose(fid);

% similar files for basic resect program

%fid=fopen('cam.inp','wt');
%fprintf(fid,'%12.6f\n',omega);
%fprintf(fid,'%12.6f\n',phi);
%fprintf(fid,'%12.6f\n',kappa);
%fprintf(fid,'%12.2f\n',XL);
%fprintf(fid,'%12.2f\n',YL);
%fprintf(fid,'%12.2f\n',ZL);
%fprintf(fid,'%8.2f\n',0.0);
%fprintf(fid,'%8.2f\n',0.0);
%fprintf(fid,'%8.2f\n',foc);
%fclose(fid);

% note: con2d not actually created anywhere
%fid=fopen('resect.inp','wt');
%for i=1:npts
%  fprintf(fid,'%5d %6.0f %6.0f %12.2f %12.2f %8.2f\n',mea2d(i,1),mea2d(i,2),mea2d(i,3),con2d(i,2),con2d(i,3),con2d(i,4));
%  end
%fclose(fid);
