/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Sequential block w reexpansion of parentheses    */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <algorithm>
#include <iostream>
#include <fstream>

//#define EXPAND_PROFILE

#include "harness.h"
#include "block.h"

#ifdef BLOCK_PROFILE
#include "blockprofiler.h"
BlockProfiler * profiler;
#endif
#ifdef PARALLELISM_PROFILE
#include "parallelismprofiler.h"
ParallelismProfiler *parallelismProfiler;
#endif

#ifdef TRACK_TRAVERSALS
uint64_t work = 0;
#endif

//int _expandDepth = 0;
long long _expandSize = D_MAX_BLOCK_SIZE;
int dynamic_reexpand_count = 0;
_Block * g_initial_block = NULL;
int g_is_partial = 0;

using namespace std;

/*Pseudo tail recursive parentheses matching our language spec*/
void parentheses(int l, int r, int n, int* num){
#ifdef BLOCK_PROFILE
  profiler->record_single();
#endif
  if (l == n){
    *num += 1;
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordNonBlockedTruncate();
#endif
    return;
  }

  if (l < r){
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordNonBlockedTruncate();
#endif
    return;
  }

  parentheses(l + 1, r, n, num);
  parentheses(l, r + 1, n, num);
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->recordNonBlockedRecurse();
#endif
}

int parentheses0(int n, _BlockStack* _stack, int* num, int _depth);
int parentheses1(int n, _BlockStack* _stack, int* num, int _depth);

/*Breadth First execution to expand the number of tasks in software block*/
void parentheses_expand_bf(int n, _BlockStack* _stack, int* num, int* _depth){
  class _BlockSet* _set = _stack->get(*_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();
#ifdef BLOCK_PROFILE
  profiler->record(_block->size, *_depth);

#ifdef EXPAND_PROFILE
  if (dynamic_reexpand_count)
  {
    profiler->record_reexpansion(*_depth);
  }

  int c_bef_exp_size[2];
  int max_c_bef_exp_size = 0;
#endif
#endif


  //Add left
  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l0;
    int r = _point.r0;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

#ifdef BLOCK_PROFILE
#ifdef EXPAND_PROFILE
  c_bef_exp_size[0] = _nextBlock0->size;
#endif
#endif

  //Add right
  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l1;
    int r = _point.r1;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

#ifdef BLOCK_PROFILE
#ifdef EXPAND_PROFILE
  c_bef_exp_size[1] =  _nextBlock0->size - c_bef_exp_size[0];
  max_c_bef_exp_size = max(c_bef_exp_size[0], c_bef_exp_size[1]);
#endif
#endif

  //Free old stack space
  if (!g_is_partial){
    if (!*_depth){
      delete g_initial_block;
    } else
    {
      _stack->release(*_depth - 1);
    }
  }

  int _nextblock0_size = _nextBlock0 -> _Block::size;
  *_depth += 1;
#ifdef BLOCK_PROFILE
#ifdef EXPAND_PROFILE
  if (dynamic_reexpand_count == 0){
    if(_nextblock0_size) {
      profiler->record_bef_exp_size(*_depth, _nextblock0_size);
#ifdef INCLUSIVE
      profiler->record_w_wo_exp_ratio(*_depth, 1);
#endif
    }
  } else{
    for (int i = 0; i < 2; ++i){
      if (c_bef_exp_size[i]) profiler->record_bef_exp_size(*_depth, c_bef_exp_size[i]);
    }
    if(_nextblock0_size) profiler->record_w_wo_exp_ratio(*_depth, ((double)_nextblock0_size) / max_c_bef_exp_size);
  }
  if(_nextblock0_size) {
    profiler->record_aft_exp_size(*_depth, _nextblock0_size);
  }

#endif
#endif

  if (_nextblock0_size > 0 && _nextblock0_size <= _expandSize / 2) {
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
    parentheses_expand_bf(n, _stack, num, _depth);
  } else { //Reach the buffer size, or finish all evaluation
    if (dynamic_reexpand_count == 0){// only print for the first time
      cout << "This is the max block buffer size for dfs: " << _nextblock0_size << endl;
    }
    if (_nextblock0_size){
      _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
      parentheses0(n, _stack, num, *_depth);
      parentheses1(n, _stack, num, *_depth);
    }
  }
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->blockEnd();
#endif

}

/*Depth First execution of left children to limit the memory consumption*/
int parentheses0(int n, _BlockStack* _stack, int* num, int _depth){
  class _BlockSet* _set = _stack->get(_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();

  int _block_size = _block->size;
  if (_block_size <= _expandSize / 2){// Do dynamic reexpansion
    dynamic_reexpand_count++;
    g_is_partial = 1;
    parentheses_expand_bf(n, _stack, num, &_depth);
    return 1;
  }

#ifdef BLOCK_PROFILE
  profiler->record(_block->size, _depth);
#endif

  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l0;
    int r = _point.r0;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;

#ifdef BLOCK_PROFILE
#ifdef EXPAND_PROFILE
    profiler->record_bef_exp_size(_depth + 1, _nextBlock0->size);
    profiler->record_aft_exp_size(_depth + 1, _nextBlock0->size);
#ifdef INCLUSIVE
    profiler->record_w_wo_exp_ratio(_depth + 1, 1);
#endif
#endif
#endif
    int skip = 0;
    skip = parentheses0( n, _stack, num, _depth + 1);
    if (!skip) parentheses1( n, _stack, num, _depth + 1);
  }
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->blockEnd();
#endif
  return 0;
}

/*Depth First execution of right children to limit the memory consumption*/
int parentheses1(int n, _BlockStack* _stack, int* num, int _depth){
  class _BlockSet* _set = _stack->get(_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();

  int _block_size = _block->size;
  if (_block_size <= _expandSize / 2){// Do dynamic reexpansion
    dynamic_reexpand_count++;
    g_is_partial = 1;
    parentheses_expand_bf(n, _stack, num, &_depth);
    return 1;
  }

#ifdef BLOCK_PROFILE
  profiler->record(_block->size, _depth);
#endif

  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l1;
    int r = _point.r1;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
#ifdef BLOCK_PROFILE
#ifdef EXPAND_PROFILE
    profiler->record_bef_exp_size(_depth + 1, _nextBlock0->size);
    profiler->record_aft_exp_size(_depth + 1, _nextBlock0->size);
#ifdef INCLUSIVE
    profiler->record_w_wo_exp_ratio(_depth + 1, 1);
#endif
#endif
#endif
    int skip = 0;
    skip = parentheses0( n, _stack, num, _depth + 1);
    if (!skip) parentheses1( n, _stack, num, _depth + 1);
  }
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->blockEnd();
#endif

  return 0;
}

/*Benchmark entrance called by harness*/
int app_main(int argc, char** argv){
  if (argc != 1 && argc != 2 && argc != 3) {
    cout << "usage: fibonacci [n] or fibonacci [n] [buffer_size, pow(2, k)]\
        or fibonacci [n] [buffer_size, pow(2, k)] [simd width]" << endl;
    exit(1);
  }

  int vec_width = 16;
  int n = atoi(argv[0]);
  if (argc >= 2) _expandSize = pow(2.0, atoi(argv[1]));
  if (argc == 3) vec_width = atoi(argv[2]);

  int num = 0;

#ifdef PARALLELISM_PROFILE
  parallelismProfiler = new ParallelismProfiler;
#endif
#ifdef BLOCK_PROFILE
  cout << "The vector width is " << vec_width << endl;
  profiler = new BlockProfiler(vec_width);
#endif

  Harness::start_timing();
  //_expandDepth = Harness::get_splice_depth();

  //Initialize software block stack
  cout << "Set fixed max block buffer size, _expandSize: " << _expandSize << endl;
  _Block::max_block = _expandSize;
  Harness::set_block_size(_expandSize);
  class _BlockStack * _stack = new _BlockStack;
  class _Block * _block = new _Block;
  g_initial_block = _block;

  if (n == 0 || n == 1){
    cout << "Please input a larger number rather than 0 or 1 ..." << endl;
    exit(0);
  }

  _block->add(1, 0, 0, 1);
  int _depth = 0;
  _stack->get (_depth) -> block = _block;

  //Start to execute blocked parentheses 
  if (_expandSize >= 2){
#ifdef BLOCK_PROFILE
#ifdef EXPAND_PROFILE
    profiler->record_bef_exp_size(0, 1);
    profiler->record_aft_exp_size(0, 1);
#ifdef INCLUSIVE
    profiler->record_w_wo_exp_ratio(0, 1);
#endif
#endif
#endif
    parentheses_expand_bf(n, _stack, &num, &_depth);
  } else{
    int df_block_size = _stack->get(_depth)->block->size;
    cout << "This is the max block buffer size for dfs: " << df_block_size << endl;

    if (df_block_size){
      parentheses0(n, _stack, &num, _depth);
      parentheses1(n, _stack, &num, _depth);
    }
  }
  delete _stack;
  if (_expandSize < 2) delete _block;

  Harness::stop_timing();

#ifdef BLOCK_PROFILE
  profiler->output();
#ifdef EXPAND_PROFILE
  profiler->outputReexpandInfo();
#endif
  delete profiler;
#endif
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->output();
  delete parallelismProfiler;
#endif

  cout << num << endl;

  cout << "This is total reexpansion counts: " << dynamic_reexpand_count << endl;
#ifdef PROFILE_SPACE_USE
  cout << "This is max space use (Bytes): " << m_space << endl;
  cout << "This is total malloc counts: " << total_malloc << endl;
#endif
  return 0;
}
