/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Sequential block wo reexpansion of parentheses   */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <algorithm>
#include <iostream>
#include <fstream>

#include "harness.h"
#include "block.h"

#ifdef BLOCK_PROFILE
#include "blockprofiler.h"
BlockProfiler profiler(16);//set simd profiler simd width as 16
#endif

#ifdef TRACK_TRAVERSALS
uint64_t work = 0;
#endif

//int _expandDepth = 0;
long long _expandSize = D_MAX_BLOCK_SIZE;

_Block * g_initial_block = NULL;

using namespace std;

/*Pseudo tail recursive parentheses matching our language spec*/
void parentheses(int l, int r, int n, int* num){
#ifdef BLOCK_PROFILE
  profiler.record_single();
#endif
  if (l == n){
    *num += 1;
    return;
  }

  if (l < r){
    return;
  }

  parentheses(l + 1, r, n, num);
  parentheses(l, r + 1, n, num);
}

/*Breadth First execution to expand the number of tasks in software block*/
void parentheses_expand_bf(int n, _BlockStack* _stack, int* num, int* _depth){
  class _BlockSet* _set = _stack->get(*_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, *_depth);
#endif

  //Add left
  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l0;
    int r = _point.r0;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

  //Add right
  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l1;
    int r = _point.r1;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

  //Free old stack space
  if (!*_depth){
    delete g_initial_block;
  } else
  {
    _stack->release(*_depth - 1);
  }

  int _nextblock0_size = _nextBlock0 -> _Block::size;
  *_depth += 1;
  if (_nextblock0_size > 0 && _nextblock0_size <= _expandSize / 2) {
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
    parentheses_expand_bf(n, _stack, num, _depth);
  } else { //Reach the buffer size, or finish all evaluation
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
  }
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->blockEnd();
#endif

}

void parentheses1(int n, _BlockStack* _stack, int* num, int _depth);

/*Depth First execution of left children to limit the memory consumption*/
void parentheses0(int n, _BlockStack* _stack, int* num, int _depth){
  class _BlockSet* _set = _stack->get(_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, _depth);
#endif

  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l0;
    int r = _point.r0;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    parentheses0( n, _stack, num, _depth + 1);
    parentheses1( n, _stack, num, _depth + 1);
  }
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->blockEnd();
#endif
}

/*Depth First execution of right children to limit the memory consumption*/
void parentheses1(int n, _BlockStack* _stack, int* num, int _depth){
  class _BlockSet* _set = _stack->get(_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, _depth);
#endif

  for (int _bi = 0; _bi < _block -> _Block::size; ++_bi) {
    class _Point &_point = _block ->  get (_bi);
    int l = _point.l1;
    int r = _point.r1;

    if (l == n){
      *num += 1;
      continue;
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }

    if (l < r){
      continue;		
#ifdef PARALLELISM_PROFILE
      parallelismProfiler->recordTruncate();
#endif
    }
    _nextBlock0->add(l + 1, r, l, r + 1);
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordRecurse();
#endif
  }

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    parentheses0( n, _stack, num, _depth + 1);
    parentheses1( n, _stack, num, _depth + 1);
  }
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->blockEnd();
#endif
}

/*Benchmark entrance called by harness*/
int app_main(int argc, char** argv){
  if (argc != 1 && argc != 2) {
    cout << "usage: parentheses [n] or parentheses [n] [buffer_size, pow(2, k)]" << endl;
    exit(1);
  }


  int n = atoi(argv[0]);
  if (argc == 2) _expandSize = pow(2.0, atoi(argv[1]));
  int num = 0;

#ifdef PARALLELISM_PROFILE
  parallelismProfiler = new ParallelismProfiler;
#endif

  Harness::start_timing();
  //_expandDepth = Harness::get_splice_depth();

  //Initialize software block stack
  cout << "Set fixed max block buffer size, _expandSize: " << _expandSize << endl;
  _Block::max_block = _expandSize;
  Harness::set_block_size(_expandSize);
  class _BlockStack * _stack = new _BlockStack;
  class _Block * _block = new _Block;
  g_initial_block = _block;

  if (n == 0 || n == 1){
    cout << "Please input a larger number rather than 0 or 1 ..." << endl;
    exit(0);
  }

  _block->add(1, 0, 0, 1);
  int _depth = 0;
  _stack->get (_depth) -> block = _block;

  //Start to execute blocked parentheses 
  if (_expandSize >= 2) parentheses_expand_bf(n, _stack, &num, &_depth);
  int df_block_size = _stack->get(_depth)->block->size;
  cout << "This is the max block buffer size for dfs: " << df_block_size << endl;

  if (df_block_size){
    parentheses0(n, _stack, &num, _depth);
    parentheses1(n, _stack, &num, _depth);
  }

  delete _stack;
  if (_expandSize < 2) delete _block;

  Harness::stop_timing();

#ifdef BLOCK_PROFILE
  profiler.output();
#ifdef BLOCKINFO
  profiler.outputBlockInfo(); //For output task distribution profile data 
#endif
#endif
#ifdef PARALLELISM_PROFILE
  parallelismProfiler->output();
  delete parallelismProfiler;
#endif

  cout << num << endl;

#ifdef PROFILE_SPACE_USE
  cout << "This is max space use (Bytes): " << m_space << endl;
  cout << "This is total malloc counts: " << total_malloc << endl;
#endif
  return 0;
}
