/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: MIC block wo reexpansion of parentheses          */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <algorithm>
#include <iostream>
#include <fstream>

#include "harness.h"
#include "block-mic.h"
#include "simd.h"

#ifdef BLOCK_PROFILE
#include "blockprofiler.h"
BlockProfiler profiler(16);
#endif

#ifdef TRACK_TRAVERSALS
uint64_t work = 0;
#endif

//int _expandDepth = 0;
long long _expandSize = D_MAX_BLOCK_SIZE;

_Block * g_initial_block = NULL;

using namespace std;

/*Pseudo tail recursive parentheses matching our language spec*/
void parentheses(int l, int r, int n, int* num){
#ifdef BLOCK_PROFILE
  profiler.record_single();
#endif
  if (l == n){
    *num += 1;
    return;
  }

  if (l < r){
    return;
  }

  parentheses(l + 1, r, n, num);
  parentheses(l, r + 1, n, num);
}


void parentheses1(int n, _BlockStack* _stack, int* num, int _depth);

/*sequential processing for left children*/
inline void process_point0(int n, _Block *_block, _Block *_nextBlock0, int _bi, int *num) {
  int l = _block->l0[_bi];
  int r = _block->r0[_bi];
  if (l == n){
    *num += 1;
    return;
  }

  if (l < r){
    return;		
  }
  _nextBlock0->add(l + 1, r, l, r + 1);
}

/*simd processing for left children, we store n in int in the block*/
inline void process_simd0_opt(int n, _Block *_block, _Block *_nextBlock0, int _si, int *num) {
  __m512i vec_l = _mm512_load_epi32((__m512i*)&_block->l0[_si]);
  __m512i vec_r = _mm512_load_epi32((__m512i*)&_block->r0[_si]);
  __m512i vec_n = _mm512_set1_epi32(n);

  __mmask16 vec_l_eq_n = _mm512_cmp_epi32_mask(vec_l, vec_n, _MM_CMPINT_EQ);

  __mmask16 vec_l_lt_r = _mm512_cmp_epi32_mask(vec_l, vec_r, _MM_CMPINT_LT);
  __mmask16 mask = _mm512_kor(vec_l_eq_n, vec_l_lt_r);

#ifdef NOSC
  //Sequential Processing
  for (int i = 0; i < MY_SIMD_WIDTH; ++i){
    int mask_tmp = (mask >> i) & 1;
    int mask_inc_tmp = (vec_l_eq_n >> i) & 1;
    if (mask_tmp){
      if (mask_inc_tmp){
        *num += 1;
      }
      continue;
    }

    int l = _block->l0[_si + i];
    int r = _block->r0[_si + i];
    _nextBlock0->add(l + 1, r, l, r + 1);
  }
#else //With Stream Compaction
  __m512i vec_1 = _mm512_set1_epi32(1);
  *num += _mm512_mask_reduce_add_epi32(vec_l_eq_n, vec_1);  

#ifdef SEQSC
  __declspec(align(64)) int tmp[MY_SIMD_WIDTH] = {0};
  __declspec(align(64)) int tmp_non_leaf[MY_SIMD_WIDTH] = {0};
  _mm512_mask_store_epi32(tmp_non_leaf, ~mask, vec_1);

  for (int i = 1; i < MY_SIMD_WIDTH; ++i){
    tmp[i] = tmp[i-1] + tmp_non_leaf[i-1];
  }

  __m512i vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), _mm512_load_epi32(tmp));

  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l1, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r0, ~mask, vec_index, vec_r, 4);

  vec_l = _mm512_add_epi32(vec_l, vec_1);
  vec_r = _mm512_add_epi32(vec_r, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l0, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r1, ~mask, vec_index, vec_r, 4);

  int adv = tmp[MY_SIMD_WIDTH - 1] + tmp_non_leaf[MY_SIMD_WIDTH - 1];
  _nextBlock0->size += adv;
#else //no SEQSC
  unsigned short low_8, high_8;
  low_8 = (~mask) & 0x00FF;
  high_8 = ((~mask) & 0xFF00) >> 8;

  __m512i vec_index = _mm512_load_epi32(g_scantable[low_8]);
  __m512i vec_index_1 = _mm512_load_epi32(g_scantable[high_8]);

  __m512i vec_index_offset = _mm512_set1_epi32(g_scantable[low_8][7] + (((~mask) >> 7) & 0x1));

  vec_index_1 = _mm512_mask_add_epi32(vec_index_1, 0x00FF, vec_index_1, vec_index_offset);
  vec_index_1 = _mm512_permute4f128_epi32(vec_index_1, _MM_PERM_BADC);
  vec_index = _mm512_and_epi32(vec_index, vec_index_1);

  vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), vec_index);

  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l1, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r0, ~mask, vec_index, vec_r, 4);

  vec_l = _mm512_add_epi32(vec_l, vec_1);
  vec_r = _mm512_add_epi32(vec_r, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l0, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r1, ~mask, vec_index, vec_r, 4);

  int adv = g_scantable[low_8][7] + g_scantable[high_8][7] + (((~mask) >> 7) & 0x1) + (((~mask) >> 15) & 0x1);
  _nextBlock0->size += adv;
#endif //NO SEQSC

#endif //SC
}


/*Depth First execution of left children to limit the memory consumption*/
void parentheses0(int n, _BlockStack* _stack, int* num, int _depth){
  class _BlockSet* _set = _stack->get(_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();

  int _si = 0;
  for (; _si < (_block -> _Block::size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point0(n, _block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd0_opt(n, _block, _nextBlock0, _si, num);
#endif // ifdef SIMD_NONE else
  }
  //Process the rest
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point0(n, _block, _nextBlock0, _bi, num);
  }

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    parentheses0( n, _stack, num, _depth + 1);
    parentheses1( n, _stack, num, _depth + 1);
  }
}

/*sequential processing for right children*/
inline void process_point1(int n, _Block *_block, _Block *_nextBlock0, int _bi, int *num) {
  int l = _block->l1[_bi];
  int r = _block->r1[_bi];

  if (l == n){
    *num += 1;
    return;
  }

  if (l < r){
    return;		
  }
  _nextBlock0->add(l + 1, r, l, r + 1);
}

/*simd processing for right children, we store n in int in the block*/
inline void process_simd1_opt(int n, _Block *_block, _Block *_nextBlock0, int _si, int *num) {
  __m512i vec_l = _mm512_load_epi32((__m512i*)&_block->l1[_si]);
  __m512i vec_r = _mm512_load_epi32((__m512i*)&_block->r1[_si]);
  __m512i vec_n = _mm512_set1_epi32(n);

  __mmask16 vec_l_eq_n = _mm512_cmp_epi32_mask(vec_l, vec_n, _MM_CMPINT_EQ);

  __mmask16 vec_l_lt_r = _mm512_cmp_epi32_mask(vec_l, vec_r, _MM_CMPINT_LT);
  __mmask16 mask = _mm512_kor(vec_l_eq_n, vec_l_lt_r);

#ifdef NOSC
  //Sequential Processing
  for (int i = 0; i < MY_SIMD_WIDTH; ++i){
    int mask_tmp = (mask >> i) & 1;
    int mask_inc_tmp = (vec_l_eq_n >> i) & 1;
    if (mask_tmp){
      if (mask_inc_tmp){
        *num += 1;
      }
      continue;
    }

    int l = _block->l1[_si + i];
    int r = _block->r1[_si + i];
    _nextBlock0->add(l + 1, r, l, r + 1);
  }
#else //With Stream Compaction
  __m512i vec_1 = _mm512_set1_epi32(1);
  *num += _mm512_mask_reduce_add_epi32(vec_l_eq_n, vec_1);  

#ifdef SEQSC
  __declspec(align(64)) int tmp[MY_SIMD_WIDTH] = {0};
  __declspec(align(64)) int tmp_non_leaf[MY_SIMD_WIDTH] = {0};
  _mm512_mask_store_epi32(tmp_non_leaf, ~mask, vec_1);

  for (int i = 1; i < MY_SIMD_WIDTH; ++i){
    tmp[i] = tmp[i-1] + tmp_non_leaf[i-1];
  }

  __m512i vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), _mm512_load_epi32(tmp));

  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l1, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r0, ~mask, vec_index, vec_r, 4);

  vec_l = _mm512_add_epi32(vec_l, vec_1);
  vec_r = _mm512_add_epi32(vec_r, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l0, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r1, ~mask, vec_index, vec_r, 4);

  int adv = tmp[MY_SIMD_WIDTH - 1] + tmp_non_leaf[MY_SIMD_WIDTH - 1];
  _nextBlock0->size += adv;
#else //no SEQSC
  unsigned short low_8, high_8;
  low_8 = (~mask) & 0x00FF;
  high_8 = ((~mask) & 0xFF00) >> 8;

  __m512i vec_index = _mm512_load_epi32(g_scantable[low_8]);
  __m512i vec_index_1 = _mm512_load_epi32(g_scantable[high_8]);

  __m512i vec_index_offset = _mm512_set1_epi32(g_scantable[low_8][7] + (((~mask) >> 7) & 0x1));

  vec_index_1 = _mm512_mask_add_epi32(vec_index_1, 0x00FF, vec_index_1, vec_index_offset);
  vec_index_1 = _mm512_permute4f128_epi32(vec_index_1, _MM_PERM_BADC);
  vec_index = _mm512_and_epi32(vec_index, vec_index_1);

  vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), vec_index);

  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l1, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r0, ~mask, vec_index, vec_r, 4);

  vec_l = _mm512_add_epi32(vec_l, vec_1);
  vec_r = _mm512_add_epi32(vec_r, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->l0, ~mask, vec_index, vec_l, 4);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->r1, ~mask, vec_index, vec_r, 4);

  int adv = g_scantable[low_8][7] + g_scantable[high_8][7] + (((~mask) >> 7) & 0x1) + (((~mask) >> 15) & 0x1);
  _nextBlock0->size += adv;
#endif //NO SEQSC

#endif //SC
}


/*Depth First execution of right children to limit the memory consumption*/
void parentheses1(int n, _BlockStack* _stack, int* num, int _depth){
  class _BlockSet* _set = _stack->get(_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();

  int _si = 0;
  for (; _si < (_block -> _Block::size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point1(n, _block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd1_opt(n, _block, _nextBlock0, _si, num);
#endif // ifdef SIMD_NONE else
  }
  //Process the rest
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point1(n, _block, _nextBlock0, _bi, num);
  }

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    parentheses0( n, _stack, num, _depth + 1);
    parentheses1( n, _stack, num, _depth + 1);
  }
}

/*Breadth First execution to expand the number of tasks in software block*/
void parentheses_expand_bf(int n, _BlockStack* _stack, int* num, int* _depth){
  class _BlockSet* _set = _stack->get(*_depth);
  class _Block* _block = _set->block;
  class _Block* _nextBlock0 = &_set-> nextBlock0;
  _nextBlock0->recycle();

  //Add Left
  int _si = 0;
  for (; _si < (_block -> _Block::size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point0(n, _block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd0_opt(n, _block, _nextBlock0, _si, num);
#endif // ifdef SIMD_NONE else
  }
  //Process the rest
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point0(n, _block, _nextBlock0, _bi, num);
  }

  //Add right
  _si = 0;
  for (; _si < (_block -> _Block::size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point1(n, _block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd1_opt(n, _block, _nextBlock0, _si, num);
#endif // ifdef SIMD_NONE else
  }
  //Process the rest
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point1(n, _block, _nextBlock0, _bi, num);
  }

  //Free old stack space
  if (!*_depth){
    delete g_initial_block;
  } else
  {
    _stack->release(*_depth - 1);
  }

  int _nextblock0_size = _nextBlock0 -> _Block::size;
  *_depth += 1;
  if (_nextblock0_size > 0 && _nextblock0_size <= _expandSize / 2) {
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
    parentheses_expand_bf(n, _stack, num, _depth);
  } else { //Reach the buffer size, or finish all evaluation
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
  }
}

/*Benchmark entrance called by harness*/
int app_main(int argc, char** argv){
  if (argc != 1 && argc != 2) {
    cout << "usage: parentheses [n] or parentheses [n] [buffer_size, pow(2, k)]" << endl;
    exit(1);
  }

  int n = atoi(argv[0]);
  if (argc == 2) _expandSize = pow(2.0, atoi(argv[1]));
  int num = 0;

  Harness::start_timing();
  //_expandDepth = Harness::get_splice_depth();

  //Initialize software block stack
  cout << "Set fixed max block buffer size, _expandSize: " << _expandSize << endl;
  _Block::max_block = _expandSize;
  Harness::set_block_size(_expandSize);
  class _BlockStack * _stack = new _BlockStack;
  class _Block * _block = new _Block;
  g_initial_block = _block;

  if (n == 0 || n == 1){
    cout << "Please input a larger number rather than 0 or 1 ..." << endl;
    exit(0);
  }

  _block->add(1, 0, 0, 1);
  int _depth = 0;
  _stack->get (_depth) -> block = _block;

  //Start to execute blocked parentheses 
  if (_expandSize >= 2) parentheses_expand_bf(n, _stack, &num, &_depth);
  int df_block_size = _stack->get(_depth)->block->size;
  cout << "This is the max block buffer size for dfs: " << df_block_size << endl;

  if (df_block_size){
    parentheses0(n, _stack, &num, _depth);
    parentheses1(n, _stack, &num, _depth);
  }

  delete _stack;
  if (_expandSize < 2) delete _block;

  Harness::stop_timing();

#ifdef BLOCK_PROFILE
  profiler.output();
  //profiler.outputBlockInfo();
#endif
  cout << num << endl;
#ifdef PROFILE_SPACE_USE
  cout << "This is max space use (Bytes): " << m_space << endl;
  cout << "This is total malloc counts: " << total_malloc << endl;
#endif
  return 0;
}
