/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Basic sequential software block stack            */
/**********************************************************/

#include <vector>
#include <cassert>

#define D_MAX_BLOCK_SIZE 128
//#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif

using namespace std;

class _Point {
 public:
  int l0, r0, l1, r1;
  _Point() {}
  _Point(int l0, int r0, int l1, int r1);
};

_Point::_Point(int l0, int r0, int l1, int r1) {
  this->l0 = l0;
  this->r0 = r0;
  this->l1 = l1;
  this->r1 = r1;
}

class _Block {
 public:
  _Block();
  ~_Block();

  void add(int l0, int r0);
  void add(int l0, int r0, int l1, int r1);
  void add(const _Point &p);
  _Point& get(int i) { return points[i]; }
  void recycle() { size = 0; }
  bool is_full() { return size == max_block; }
  bool is_empty() { return size == 0; }

  _Point* points;
  int size;

  static long long max_block;
};

class _BlockSet
{
 public:
  _BlockSet() {}
  ~_BlockSet() {}

  _Block *block;
  _Block nextBlock0;
};

class _BlockStack
{
 public:
  _BlockStack() { }
  ~_BlockStack();

  _BlockSet* get(int i);
  void release(int _depth){
    delete this->items[_depth];
    this->items[_depth] = NULL;
  }

  vector<_BlockSet *> items;
};

long long _Block::max_block = 1024;

_Block::_Block() {
  points = new _Point[max_block];
  size = 0;
#ifdef PROFILE_SPACE_USE
  c_space += max_block * sizeof(_Point);
  m_space = max(m_space, c_space);
  total_malloc++;
#endif
}

_Block::~_Block() {
  delete [] points;
#ifdef PROFILE_SPACE_USE
  c_space -= max_block * sizeof(_Point);
  m_space = max(m_space, c_space);
#endif
}

void _Block::add(int l0, int r0) {
  assert(size < max_block);
  points[size].l0 = l0;
  points[size].r0 = r0;
  size++;
}

inline void _Block::add(int l0, int r0, int l1, int r1) {
  assert(size < max_block);
  points[size].l0 = l0;
  points[size].r0 = r0;
  points[size].l1 = l1;
  points[size].r1 = r1;
  size++;
}

void _Block::add(const _Point &p) {
  assert(size < max_block);
  points[size] = p;
  size++;
}

_BlockStack::~_BlockStack() {
  for (int i = 0; i < items.size(); i++) {
    if (items[i]) delete items[i];
  }
}

inline _BlockSet* _BlockStack::get(int i) {
  while (i >= items.size()) {
    items.push_back(new _BlockSet());
  }
  return items[i];
}
