/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Software block stack for SSE                     */
/**********************************************************/

#include <vector>
#include <cassert>
#include <stdlib.h>

#define D_MAX_BLOCK_SIZE 128
#define MY_SIMD_WIDTH 16
//#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif

int g_ncheck = 0;
#define BOARD_SIZE 4
#define POS_SIZE 17//Corresponding to BOARD_SIZE
#define NOMOVE 100

using namespace std;

class _Block {
 public:
  _Block();
  ~_Block();

  void add(char *b, int n, char startpos);
  void addcol(char *b, int bi, int n, char startpos);
  void add(_Block *block, int bi, int n);
  char get(int _bi, int n) { return a[n * max_block + _bi]; }
  char *getptr(int _bi, int n) { return &a[n * max_block + _bi]; }
  char *getcol(int _bi){
    char* tmp = (char*)malloc(sizeof(char) * POS_SIZE);
    for (int i = 0; i < _Block::n; ++i){
      tmp[i] = this->a[i * max_block + _bi];
    }
    return tmp;
  }
  void set(int _bi, int n, int val) { a[n * max_block + _bi] = val; }
  void recycle() { size = 0; }
  bool is_full() { return size == max_block; }
  bool is_empty() { return size == 0; }

  char *a;
  char *startpos;
  int size;

  static int max_block;
  static int n; // == POS_SIZE
};

class _BlockSet
{
 public:
  _BlockSet() {}
  ~_BlockSet() {}

  _Block *block;
  _Block nextBlock0;
};

class _BlockStack
{
 public:
  _BlockStack() {}
  ~_BlockStack();

  _BlockSet* get(int i);
  void release(int _depth){
    delete this->items[_depth];
    this->items[_depth] = NULL;
  }
  vector<_BlockSet *> items;
};

int _Block::max_block = D_MAX_BLOCK_SIZE ;
int _Block::n;

_Block::_Block() {
  a = new char[max_block * n];
  startpos = new char[max_block];
  size = 0;
#ifdef PROFILE_SPACE_USE
  c_space += max_block * sizeof(char) * n;
  m_space = max(m_space, c_space);
  total_malloc++;
#endif
}

_Block::~_Block() {
  delete [] a;
  delete [] startpos;
#ifdef PROFILE_SPACE_USE
  c_space -= max_block * sizeof(char) * n;
  m_space = max(m_space, c_space);
#endif
}

void _Block::add(char *b, int n, char startpos) {
  assert(size < max_block);
  for (int i = 0; i < n; i++) {
    a[i * max_block + size] = b[i];
  }
  this->startpos[size] = startpos;
  size++;
}

void _Block::addcol(char *b, int bi, int n, char startpos) {
  assert(size < max_block);
  for (int i = 0; i < n; i++) {
    a[i * max_block + size] = b[i * MY_SIMD_WIDTH + bi];
  }
  this->startpos[size] = startpos;
  size++;
}


void _Block::add(_Block *block, int bi, int n) {
  assert(size < max_block);
  for (int i = 0; i < n; i++) {
    a[i * max_block + size] = block->a[i * max_block + bi];
  }
  size++;
}

_BlockStack::~_BlockStack() {
  for (int i = 0; i < items.size(); i++) {
    delete items[i];
  }
}

_BlockSet* _BlockStack::get(int i) {
  while (i >= items.size()) {
    items.push_back(new _BlockSet());
  }
  return items[i];
}

//#define __int64 uint64_t

__attribute__((aligned(64))) static const __int64 g_shuffletable[] = {
  /*0*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)5<<40)|((__int64)6<<48)|((__int64)7<<56),
  /*1*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40)|((__int64)7<<48),
  /*2*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40)|((__int64)7<<48),
  /*3*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*4*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40)|((__int64)7<<48),
  /*5*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*6*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*7*/3|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*8*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40)|((__int64)7<<48),
  /*9*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*10*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*11*/2|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*12*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*13*/1|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*14*/0|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*15*/4|((__int64)5<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*16*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)5<<32)|((__int64)6<<40)|((__int64)7<<48),
  /*17*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*18*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*19*/2|((__int64)3<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*20*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*21*/1|((__int64)3<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*22*/0|((__int64)3<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*23*/3|((__int64)5<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*24*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)5<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*25*/1|((__int64)2<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*26*/0|((__int64)2<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*27*/2|((__int64)5<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*28*/0|((__int64)1<<8)|((__int64)5<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*29*/1|((__int64)5<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*30*/0|((__int64)5<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*31*/5|((__int64)6<<8)|((__int64)7<<16),
  /*32*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)6<<40)|((__int64)7<<48),
  /*33*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*34*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*35*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*36*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*37*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*38*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*39*/3|((__int64)4<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*40*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*41*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*42*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*43*/2|((__int64)4<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*44*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*45*/1|((__int64)4<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*46*/0|((__int64)4<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*47*/4|((__int64)6<<8)|((__int64)7<<16),
  /*48*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)6<<32)|((__int64)7<<40),
  /*49*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*50*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*51*/2|((__int64)3<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*52*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*53*/1|((__int64)3<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*54*/0|((__int64)3<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*55*/3|((__int64)6<<8)|((__int64)7<<16),
  /*56*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)6<<24)|((__int64)7<<32),
  /*57*/1|((__int64)2<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*58*/0|((__int64)2<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*59*/2|((__int64)6<<8)|((__int64)7<<16),
  /*60*/0|((__int64)1<<8)|((__int64)6<<16)|((__int64)7<<24),
  /*61*/1|((__int64)6<<8)|((__int64)7<<16),
  /*62*/0|((__int64)6<<8)|((__int64)7<<16),
  /*63*/6|((__int64)7<<8),
  /*64*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)5<<40)|((__int64)7<<48),
  /*65*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)7<<40),
  /*66*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)7<<40),
  /*67*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*68*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)7<<40),
  /*69*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*70*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*71*/3|((__int64)4<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*72*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)7<<40),
  /*73*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*74*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*75*/2|((__int64)4<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*76*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*77*/1|((__int64)4<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*78*/0|((__int64)4<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*79*/4|((__int64)5<<8)|((__int64)7<<16),
  /*80*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)5<<32)|((__int64)7<<40),
  /*81*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*82*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*83*/2|((__int64)3<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*84*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*85*/1|((__int64)3<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*86*/0|((__int64)3<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*87*/3|((__int64)5<<8)|((__int64)7<<16),
  /*88*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)5<<24)|((__int64)7<<32),
  /*89*/1|((__int64)2<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*90*/0|((__int64)2<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*91*/2|((__int64)5<<8)|((__int64)7<<16),
  /*92*/0|((__int64)1<<8)|((__int64)5<<16)|((__int64)7<<24),
  /*93*/1|((__int64)5<<8)|((__int64)7<<16),
  /*94*/0|((__int64)5<<8)|((__int64)7<<16),
  /*95*/5|((__int64)7<<8),
  /*96*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)7<<40),
  /*97*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)7<<32),
  /*98*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)7<<32),
  /*99*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)7<<24),
  /*100*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)7<<32),
  /*101*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)7<<24),
  /*102*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)7<<24),
  /*103*/3|((__int64)4<<8)|((__int64)7<<16),
  /*104*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)7<<32),
  /*105*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)7<<24),
  /*106*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)7<<24),
  /*107*/2|((__int64)4<<8)|((__int64)7<<16),
  /*108*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)7<<24),
  /*109*/1|((__int64)4<<8)|((__int64)7<<16),
  /*110*/0|((__int64)4<<8)|((__int64)7<<16),
  /*111*/4|((__int64)7<<8),
  /*112*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)7<<32),
  /*113*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)7<<24),
  /*114*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)7<<24),
  /*115*/2|((__int64)3<<8)|((__int64)7<<16),
  /*116*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)7<<24),
  /*117*/1|((__int64)3<<8)|((__int64)7<<16),
  /*118*/0|((__int64)3<<8)|((__int64)7<<16),
  /*119*/3|((__int64)7<<8),
  /*120*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)7<<24),
  /*121*/1|((__int64)2<<8)|((__int64)7<<16),
  /*122*/0|((__int64)2<<8)|((__int64)7<<16),
  /*123*/2|((__int64)7<<8),
  /*124*/0|((__int64)1<<8)|((__int64)7<<16),
  /*125*/1|((__int64)7<<8),
  /*126*/0|((__int64)7<<8),
  /*127*/7,
  /*128*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)5<<40)|((__int64)6<<48),
  /*129*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40),
  /*130*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40),
  /*131*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*132*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40),
  /*133*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*134*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*135*/3|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*136*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)5<<32)|((__int64)6<<40),
  /*137*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*138*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*139*/2|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*140*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*141*/1|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*142*/0|((__int64)4<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*143*/4|((__int64)5<<8)|((__int64)6<<16),
  /*144*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)5<<32)|((__int64)6<<40),
  /*145*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*146*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*147*/2|((__int64)3<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*148*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*149*/1|((__int64)3<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*150*/0|((__int64)3<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*151*/3|((__int64)5<<8)|((__int64)6<<16),
  /*152*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)5<<24)|((__int64)6<<32),
  /*153*/1|((__int64)2<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*154*/0|((__int64)2<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*155*/2|((__int64)5<<8)|((__int64)6<<16),
  /*156*/0|((__int64)1<<8)|((__int64)5<<16)|((__int64)6<<24),
  /*157*/1|((__int64)5<<8)|((__int64)6<<16),
  /*158*/0|((__int64)5<<8)|((__int64)6<<16),
  /*159*/5|((__int64)6<<8),
  /*160*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)6<<40),
  /*161*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)6<<32),
  /*162*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)6<<32),
  /*163*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)6<<24),
  /*164*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)6<<32),
  /*165*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)6<<24),
  /*166*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)6<<24),
  /*167*/3|((__int64)4<<8)|((__int64)6<<16),
  /*168*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)6<<32),
  /*169*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)6<<24),
  /*170*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)6<<24),
  /*171*/2|((__int64)4<<8)|((__int64)6<<16),
  /*172*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)6<<24),
  /*173*/1|((__int64)4<<8)|((__int64)6<<16),
  /*174*/0|((__int64)4<<8)|((__int64)6<<16),
  /*175*/4|((__int64)6<<8),
  /*176*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)6<<32),
  /*177*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)6<<24),
  /*178*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)6<<24),
  /*179*/2|((__int64)3<<8)|((__int64)6<<16),
  /*180*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)6<<24),
  /*181*/1|((__int64)3<<8)|((__int64)6<<16),
  /*182*/0|((__int64)3<<8)|((__int64)6<<16),
  /*183*/3|((__int64)6<<8),
  /*184*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)6<<24),
  /*185*/1|((__int64)2<<8)|((__int64)6<<16),
  /*186*/0|((__int64)2<<8)|((__int64)6<<16),
  /*187*/2|((__int64)6<<8),
  /*188*/0|((__int64)1<<8)|((__int64)6<<16),
  /*189*/1|((__int64)6<<8),
  /*190*/0|((__int64)6<<8),
  /*191*/6,
  /*192*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32)|((__int64)5<<40),
  /*193*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32),
  /*194*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32),
  /*195*/2|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24),
  /*196*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24)|((__int64)5<<32),
  /*197*/1|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24),
  /*198*/0|((__int64)3<<8)|((__int64)4<<16)|((__int64)5<<24),
  /*199*/3|((__int64)4<<8)|((__int64)5<<16),
  /*200*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24)|((__int64)5<<32),
  /*201*/1|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24),
  /*202*/0|((__int64)2<<8)|((__int64)4<<16)|((__int64)5<<24),
  /*203*/2|((__int64)4<<8)|((__int64)5<<16),
  /*204*/0|((__int64)1<<8)|((__int64)4<<16)|((__int64)5<<24),
  /*205*/1|((__int64)4<<8)|((__int64)5<<16),
  /*206*/0|((__int64)4<<8)|((__int64)5<<16),
  /*207*/4|((__int64)5<<8),
  /*208*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)5<<32),
  /*209*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24),
  /*210*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)5<<24),
  /*211*/2|((__int64)3<<8)|((__int64)5<<16),
  /*212*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)5<<24),
  /*213*/1|((__int64)3<<8)|((__int64)5<<16),
  /*214*/0|((__int64)3<<8)|((__int64)5<<16),
  /*215*/3|((__int64)5<<8),
  /*216*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)5<<24),
  /*217*/1|((__int64)2<<8)|((__int64)5<<16),
  /*218*/0|((__int64)2<<8)|((__int64)5<<16),
  /*219*/2|((__int64)5<<8),
  /*220*/0|((__int64)1<<8)|((__int64)5<<16),
  /*221*/1|((__int64)5<<8),
  /*222*/0|((__int64)5<<8),
  /*223*/5,
  /*224*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24)|((__int64)4<<32),
  /*225*/1|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24),
  /*226*/0|((__int64)2<<8)|((__int64)3<<16)|((__int64)4<<24),
  /*227*/2|((__int64)3<<8)|((__int64)4<<16),
  /*228*/0|((__int64)1<<8)|((__int64)3<<16)|((__int64)4<<24),
  /*229*/1|((__int64)3<<8)|((__int64)4<<16),
  /*230*/0|((__int64)3<<8)|((__int64)4<<16),
  /*231*/3|((__int64)4<<8),
  /*232*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)4<<24),
  /*233*/1|((__int64)2<<8)|((__int64)4<<16),
  /*234*/0|((__int64)2<<8)|((__int64)4<<16),
  /*235*/2|((__int64)4<<8),
  /*236*/0|((__int64)1<<8)|((__int64)4<<16),
  /*237*/1|((__int64)4<<8),
  /*238*/0|((__int64)4<<8),
  /*239*/4,
  /*240*/0|((__int64)1<<8)|((__int64)2<<16)|((__int64)3<<24),
  /*241*/1|((__int64)2<<8)|((__int64)3<<16),
  /*242*/0|((__int64)2<<8)|((__int64)3<<16),
  /*243*/2|((__int64)3<<8),
  /*244*/0|((__int64)1<<8)|((__int64)3<<16),
  /*245*/1|((__int64)3<<8),
  /*246*/0|((__int64)3<<8),
  /*247*/3,
  /*248*/0|((__int64)1<<8)|((__int64)2<<16),
  /*249*/1|((__int64)2<<8),
  /*250*/0|((__int64)2<<8),
  /*251*/2,
  /*252*/0|((__int64)1<<8),
  /*253*/1,
  /*254*/0,
  /*255*/255,
};


static const unsigned char g_advanceNextPtrCounts[] = {
  /*0*/8,
  /*1*/7,
  /*2*/7,
  /*3*/6,
  /*4*/7,
  /*5*/6,
  /*6*/6,
  /*7*/5,
  /*8*/7,
  /*9*/6,
  /*10*/6,
  /*11*/5,
  /*12*/6,
  /*13*/5,
  /*14*/5,
  /*15*/4,
  /*16*/7,
  /*17*/6,
  /*18*/6,
  /*19*/5,
  /*20*/6,
  /*21*/5,
  /*22*/5,
  /*23*/4,
  /*24*/6,
  /*25*/5,
  /*26*/5,
  /*27*/4,
  /*28*/5,
  /*29*/4,
  /*30*/4,
  /*31*/3,
  /*32*/7,
  /*33*/6,
  /*34*/6,
  /*35*/5,
  /*36*/6,
  /*37*/5,
  /*38*/5,
  /*39*/4,
  /*40*/6,
  /*41*/5,
  /*42*/5,
  /*43*/4,
  /*44*/5,
  /*45*/4,
  /*46*/4,
  /*47*/3,
  /*48*/6,
  /*49*/5,
  /*50*/5,
  /*51*/4,
  /*52*/5,
  /*53*/4,
  /*54*/4,
  /*55*/3,
  /*56*/5,
  /*57*/4,
  /*58*/4,
  /*59*/3,
  /*60*/4,
  /*61*/3,
  /*62*/3,
  /*63*/2,
  /*64*/7,
  /*65*/6,
  /*66*/6,
  /*67*/5,
  /*68*/6,
  /*69*/5,
  /*70*/5,
  /*71*/4,
  /*72*/6,
  /*73*/5,
  /*74*/5,
  /*75*/4,
  /*76*/5,
  /*77*/4,
  /*78*/4,
  /*79*/3,
  /*80*/6,
  /*81*/5,
  /*82*/5,
  /*83*/4,
  /*84*/5,
  /*85*/4,
  /*86*/4,
  /*87*/3,
  /*88*/5,
  /*89*/4,
  /*90*/4,
  /*91*/3,
  /*92*/4,
  /*93*/3,
  /*94*/3,
  /*95*/2,
  /*96*/6,
  /*97*/5,
  /*98*/5,
  /*99*/4,
  /*100*/5,
  /*101*/4,
  /*102*/4,
  /*103*/3,
  /*104*/5,
  /*105*/4,
  /*106*/4,
  /*107*/3,
  /*108*/4,
  /*109*/3,
  /*110*/3,
  /*111*/2,
  /*112*/5,
  /*113*/4,
  /*114*/4,
  /*115*/3,
  /*116*/4,
  /*117*/3,
  /*118*/3,
  /*119*/2,
  /*120*/4,
  /*121*/3,
  /*122*/3,
  /*123*/2,
  /*124*/3,
  /*125*/2,
  /*126*/2,
  /*127*/1,
  /*128*/7,
  /*129*/6,
  /*130*/6,
  /*131*/5,
  /*132*/6,
  /*133*/5,
  /*134*/5,
  /*135*/4,
  /*136*/6,
  /*137*/5,
  /*138*/5,
  /*139*/4,
  /*140*/5,
  /*141*/4,
  /*142*/4,
  /*143*/3,
  /*144*/6,
  /*145*/5,
  /*146*/5,
  /*147*/4,
  /*148*/5,
  /*149*/4,
  /*150*/4,
  /*151*/3,
  /*152*/5,
  /*153*/4,
  /*154*/4,
  /*155*/3,
  /*156*/4,
  /*157*/3,
  /*158*/3,
  /*159*/2,
  /*160*/6,
  /*161*/5,
  /*162*/5,
  /*163*/4,
  /*164*/5,
  /*165*/4,
  /*166*/4,
  /*167*/3,
  /*168*/5,
  /*169*/4,
  /*170*/4,
  /*171*/3,
  /*172*/4,
  /*173*/3,
  /*174*/3,
  /*175*/2,
  /*176*/5,
  /*177*/4,
  /*178*/4,
  /*179*/3,
  /*180*/4,
  /*181*/3,
  /*182*/3,
  /*183*/2,
  /*184*/4,
  /*185*/3,
  /*186*/3,
  /*187*/2,
  /*188*/3,
  /*189*/2,
  /*190*/2,
  /*191*/1,
  /*192*/6,
  /*193*/5,
  /*194*/5,
  /*195*/4,
  /*196*/5,
  /*197*/4,
  /*198*/4,
  /*199*/3,
  /*200*/5,
  /*201*/4,
  /*202*/4,
  /*203*/3,
  /*204*/4,
  /*205*/3,
  /*206*/3,
  /*207*/2,
  /*208*/5,
  /*209*/4,
  /*210*/4,
  /*211*/3,
  /*212*/4,
  /*213*/3,
  /*214*/3,
  /*215*/2,
  /*216*/4,
  /*217*/3,
  /*218*/3,
  /*219*/2,
  /*220*/3,
  /*221*/2,
  /*222*/2,
  /*223*/1,
  /*224*/5,
  /*225*/4,
  /*226*/4,
  /*227*/3,
  /*228*/4,
  /*229*/3,
  /*230*/3,
  /*231*/2,
  /*232*/4,
  /*233*/3,
  /*234*/3,
  /*235*/2,
  /*236*/3,
  /*237*/2,
  /*238*/2,
  /*239*/1,
  /*240*/4,
  /*241*/3,
  /*242*/3,
  /*243*/2,
  /*244*/3,
  /*245*/2,
  /*246*/2,
  /*247*/1,
  /*248*/3,
  /*249*/2,
  /*250*/2,
  /*251*/1,
  /*252*/2,
  /*253*/1,
  /*254*/1,
  /*255*/0,
};

