/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Basic sequential software block stack            */
/**********************************************************/

#include <vector>
#include <cassert>

#define D_MAX_BLOCK_SIZE 1
//#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif

using namespace std;

class _Point {
 public:
  int c0, v0, c1, v1;
  _Point() {}
  _Point(int c0, int v0, int c1, int v1);
};

_Point::_Point(int c0, int v0, int c1, int v1) {
  this->c0 = c0;
  this->v0 = v0;
  this->c1 = c1;
  this->v1 = v1;
}

class _Block {
 public:
  _Block();
  ~_Block();

  void add(int c0, int v0);
  void add(int c0, int v0, int c1, int v1);
  void add(const _Point &p);
  _Point& get(int i) { return points[i]; }
  void recycle() { size = 0; }
  bool is_full() { return size == max_block; }
  bool is_empty() { return size == 0; }

  _Point* points;
  int size;

  static long long max_block;
};

class _BlockSet
{
 public:
  _BlockSet() {}
  ~_BlockSet() {}

  _Block *block;
  _Block nextBlock0;
};

class _BlockStack
{
 public:
  _BlockStack() { }
  ~_BlockStack();

  _BlockSet* get(int i);
  void release(int _depth){
    delete this->items[_depth];
    this->items[_depth] = NULL;
  }

  vector<_BlockSet *> items;
};

long long _Block::max_block = 1024;

_Block::_Block() {
  points = new _Point[max_block];
  size = 0;
#ifdef PROFILE_SPACE_USE
  c_space += max_block * sizeof(_Point);
  m_space = max(m_space, c_space);
  total_malloc++;
#endif
}

_Block::~_Block() {
  delete [] points;
#ifdef PROFILE_SPACE_USE
  c_space -= max_block * sizeof(_Point);
  m_space = max(m_space, c_space);
#endif
}

void _Block::add(int c0, int v0) {
  assert(size < max_block);
  points[size].c0 = c0;
  points[size].v0 = v0;
  size++;
}

inline void _Block::add(int c0, int v0, int c1, int v1) {
  assert(size < max_block);
  points[size].c0 = c0;
  points[size].v0 = v0;
  points[size].c1 = c1;
  points[size].v1 = v1;
  size++;
}

void _Block::add(const _Point &p) {
  assert(size < max_block);
  points[size] = p;
  size++;
}

_BlockStack::~_BlockStack() {
  for (int i = 0; i < items.size(); i++) {
    if (items[i]) delete items[i];
  }
}

inline _BlockSet* _BlockStack::get(int i) {
  while (i >= items.size()) {
    items.push_back(new _BlockSet());
  }
  return items[i];
}
