/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Software block stack for MIC                     */
/**********************************************************/

#include <vector>
#include <cassert>

#define node_t int  
#define MY_MIN INT_MIN
const int MY_SIMD_WIDTH = 16;
#define D_MAX_BLOCK_SIZE 1

//#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif

using namespace std;

class _Point {
public:
	node_t c0, v0, c1, v1;
	_Point() {}
	_Point(node_t c0, node_t v0, node_t c1, node_t v1);
};

_Point::_Point(node_t c0, node_t v0, node_t c1, node_t v1) {
	this->c0 = c0;
	this->v0 = v0;
	this->c1 = c1;
	this->v1 = v1;
}

class _Block {
public:
	_Block();
	~_Block();

	void add(node_t c0, node_t v0, node_t c1, node_t v1);
	void recycle() { size = 0; }
	bool is_full() { return size == max_block; }
	bool is_empty() { return size == 0; }

	__declspec(align(64)) node_t *c0;
	__declspec(align(64)) node_t *v0;
	__declspec(align(64)) node_t *c1;
	__declspec(align(64)) node_t *v1;

	int size;

	static long long max_block;
};

class _BlockSet
{
public:
	_BlockSet() {}
	~_BlockSet() {}

	_Block *block;
	_Block nextBlock0;
};

#define _BLOCKSET_SIZE 64
class _BlockStack
{
public:
	_BlockStack() { }
	~_BlockStack();

	_BlockSet* get(int i);
    void release(int _depth){
        delete this->items[_depth];
        this->items[_depth] = NULL;
    }

	vector<_BlockSet *> items;
};

long long _Block::max_block = 1024;

_Block::_Block() {
	c0 = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);
	v0 = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);
	c1 = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);
	v1 = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);

	size = 0;
#ifdef PROFILE_SPACE_USE
    c_space += max_block * sizeof(node_t) * 4;
    m_space = max(m_space, c_space);
    total_malloc++;
#endif

}

_Block::~_Block() {
	_mm_free(c0);
	_mm_free(v0);
	_mm_free(c1);
	_mm_free(v1);

#ifdef PROFILE_SPACE_USE
    c_space -= max_block * sizeof(node_t) * 4;
    m_space = max(m_space, c_space);
#endif
}

inline void _Block::add(node_t c0, node_t v0, node_t c1, node_t v1) {
	assert(size < max_block);
	this->c0[size] = c0;
	this->v0[size] = v0;
	this->c1[size] = c1;
	this->v1[size] = v1;
	size++;
}

_BlockStack::~_BlockStack() {
	for (int i = 0; i < items.size(); i++) {
		if (items[i]) delete items[i];
	}
}

inline _BlockSet* _BlockStack::get(int i) {
	while (i >= items.size()) {
		items.push_back(new _BlockSet());
	}
	return items[i];
}

__declspec(align(64)) static const int g_scantable[256][16] = {
0,  0,  0,  0,  0,  0,  0,  0,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  0,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  7,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  0,  0,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  0,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  7,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF 
};



