/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: SSE block wo reexpansion of graphcol             */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <string.h>
#include <iostream>
#include <fstream>

#include "harness.h"
#include "simd.h"	// must precede block.h
#include "block-sse.h"

#ifdef BLOCK_PROFILE
#include "blockprofiler.h"
BlockProfiler profiler(16);//set simd profiler simd width as 16
#endif

#ifdef TRACK_TRAVERSALS
uint64_t work = 0;
#endif

_Block * g_initial_block = NULL;

using namespace std;

//int _expandDepth = 0;
long long _expandSize = D_MAX_BLOCK_SIZE;
int _cleanupThreshold = 1;
#define DATAFILE "../inputs/data38N64E.col"
_MM_ALIGNED_ node_t * adjacentNodes; //Graph Pointer, in adjacent matrix format
int numColor = 0;

void readEdge(FILE *data, int numEdge, int numNode, int *edge)
{
  char tmp[50];
  for(int i = 0; i < numEdge; i++)
  {
    fscanf(data, "%s %d %d\n", tmp, &edge[i*2], &edge[i*2+1]);
    edge[i*2]--;
    edge[i*2+1]--;
  }
}

void init_graph(int numNode, int numEdge, int* edge){
  adjacentNodes = (node_t *)malloc(numNode*numNode*sizeof(node_t));
  memset(adjacentNodes, 0, numNode*numNode*sizeof(node_t));

  for (int t = 0; t < numEdge; t++){
    adjacentNodes[edge[t*2]*numNode + edge[t*2+1]]
        = adjacentNodes[edge[t*2+1]*numNode + edge[t*2]]
        = 1;
  }
}

void print_graph(int numNode){
  printf("This is the graph: \n");
  for (int i = 0; i < numNode; ++i){
    for (int j = 0; j < numNode; ++j){
      printf("%d ", adjacentNodes[i*numNode+j]);
    }
    printf("\n");
  }
}

bool ok(int nodeId, int ci, node_t* c, int numNode){
  for (int k = 0; k < nodeId; ++k){
    for (int i = k + 1; i <= nodeId; ++i){
      if (adjacentNodes[k * numNode + i] == 1 && c[k] == c[i]){
        return false;
      }
    }
  }
  return true;
}


void print_solution(node_t* c, int numNode){
  printf("This is a solution: \n");
  for (int i = 0; i < numNode; ++i){
    printf("%d ", c[i]);
  }
  printf("\n");
}

/*Pseudo tail recursive graphcol matching our language spec*/
void color(int nodeId, int numNode, int numColor, node_t* c, int *numSolution, int _callIndex){
#ifdef TRACK_TRAVERSALS
  work++;
#endif
#ifdef BLOCK_PROFILE
  profiler.record_single();
#endif

  if (_callIndex != -1){
    c[nodeId - 1] = _callIndex;
    if (!ok(nodeId - 1, _callIndex, c, numNode)) return;
  }

  if (nodeId == numNode){
    *numSolution += 1;
#ifdef _DEBUG
    if (*numSolution % 1000 == 0) print_solution(c, numNode);
#endif
    return;
  }

  //For current node, try color from color id = 1
  for (int ci = 1; ci <= numColor; ++ci){
    color(nodeId + 1, numNode, numColor, c, numSolution, ci);
  }
}

/*sequential check for blocked code*/
bool ok(int nodeId, _Block* _block, int _bi, int ci, int numNode){
  for (int k = 0; k < nodeId; ++k){
    for (int i = k + 1; i <= nodeId; ++i){
      if (adjacentNodes[k * numNode + i] == 1 && _block->get(_bi, k) == _block->get(_bi, i)){
        return false;
      }
    }
  }
  return true;
}

/*sequential processing for Depth First Execution*/
inline void process_point(_Block* _block, int _bi, int nodeId, int _callIndex, int numNode, int* numSolution, _Block* _nextBlock0){
  _block->set(_bi, nodeId - 1, _callIndex);
  if (!ok(nodeId - 1, _block, _bi, _callIndex, numNode)){
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordNonBlockedTruncate();
#endif
    return;
  }

  if (nodeId == numNode){
    *numSolution += 1;
#ifdef _DEBUG
    if (*numSolution % 1000 == 0) print_solution(c, numNode);
#endif
#ifdef PARALLELISM_PROFILE
    parallelismProfiler->recordNonBlockedTruncate();
#endif
    return;
  }

#ifdef PARALLELISM_PROFILE
  parallelismProfiler->recordNonBlockedRecurse();
#endif

  _nextBlock0->add(_block, _bi, nodeId);
}

/*simd check for blocked code*/
inline void ok_vec(int nodeId, _Block* _block, int _si, int numNode, int* ret_mask){
  for (int k = 0; k < nodeId; ++k){
    __m128i vec_ck = _mm_loadu_si128((__m128i*)_block->getptr(_si, k));
    for (int i = k + 1; i <= nodeId; ++i){
      if (adjacentNodes[k * numNode + i] == 1){
        __m128i vec_ci = _mm_loadu_si128((__m128i*)_block->getptr(_si, i));
        __m128i vec_cmp = _mm_cmpeq_epi8(vec_ck, vec_ci);
        int mask = _mm_movemask_epi8(vec_cmp);
        *ret_mask = *ret_mask | mask;
        if (*ret_mask == 0xffff) return;
      }
    }
  }
}

/*simd processing for Depth First Execution, we store n in char in the block*/
inline void process_simd(_Block* _block, int _si, int nodeId, int _callIndex, int numNode, int* numSolution, _Block* _nextBlock0){
  __m128i vec_callIndex = _mm_set1_epi8(_callIndex);
  node_t *dest = _block->getptr(_si, nodeId - 1);
  _mm_storeu_si128((__m128i*)dest, vec_callIndex);
  int ret_mask = 0;
  ok_vec(nodeId - 1, _block, _si, numNode, &ret_mask);
  if (ret_mask == 0xffff) return;
  int ok_mask = ~ret_mask;

  if (nodeId == numNode) {
    for (int i = 0; i < MY_SIMD_WIDTH; i++) {
      int f = 1 << i;
      if (f & ok_mask) *numSolution += 1;
    }
  } else {
    for (int i = 0; i < MY_SIMD_WIDTH; i++) {
      int f = 1 << i;
      if (f & ok_mask) _nextBlock0->add(_block, _si + i, nodeId);
    }
  }
}


/*Depth First execution of i-th children to limit the memory consumption*/
void color_block(_BlockStack *_stack, int _depth, int* num, int _callIndex, int n) {
  class _BlockSet *_set = _stack ->  get (_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, _depth);
#endif

  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
    process_simd(_block, _si, _depth + 1, _callIndex, g_nnodes, num, _nextBlock0);
  }

  //Process the rest
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point(_block, _bi, _depth + 1, _callIndex, g_nnodes, num, _nextBlock0);

  }
  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    for (int i = 1; i <= numColor; i++) {
      color_block(_stack, _depth + 1, num, i, n);
    }
  }
}


/*sequential processing for Breadth First Execution*/
inline void process_point_bf(_Block *_block, _Block *_nextBlock0, int _bi, char n, char j, int _callIndex, int *num) {
  _block->set(_bi, j - 1, _callIndex);
  if (!ok(j-1, _block, _bi, _callIndex, g_nnodes)) return;

  _nextBlock0->add(_block, _bi, j);
}

/*simd processing for Breadth First Execution, we store n in char in the block*/
inline void process_simd_bf(_Block *_block, _Block *_nextBlock0, int _si, char n, char j, int _callIndex, int *num) {
  __m128i vec_callIndex = _mm_set1_epi8(_callIndex);
  char *dest = _block->getptr(_si, j - 1);
  _mm_storeu_si128((__m128i*)dest, vec_callIndex);
  int ret_mask = 0;
  ok_vec(j - 1, _block, _si, g_nnodes, &ret_mask);
  if (ret_mask == 0xffff) return;
  int ok_mask = ~ret_mask;


  for (int i = 0; i < MY_SIMD_WIDTH; i++) {
    int f = 1 << i;
    if (f & ok_mask) _nextBlock0->add(_block, _si + i, j);
  }
}


/*Breadth First execution to expand the number of tasks in software block*/
void color_expand_bf(_BlockStack* _stack, int* _depth, int* num, int n){
  class _BlockSet *_set = _stack ->  get (*_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, *_depth);
#endif

  if (n == *_depth) {
    *num += _block->size;
  } else {
    for(int i = 1; i <= numColor; ++i){
      int _si = 0;
      for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
        process_simd_bf(_block, _nextBlock0, _si, n, *_depth + 1, i, num);
      }
      //Process the rest
      for (int _bi = _si; _bi < _block->size; _bi++) {
        process_point_bf(_block, _nextBlock0, _bi, n, *_depth + 1, i, num);

      }
    }
  }

  //Free old stack space
  if (!*_depth){
    delete g_initial_block;
  } else
  {
    _stack->release(*_depth - 1);
  }

  int _nextblock0_size = _nextBlock0 -> _Block::size;
#ifdef _DEBUG
  cout << "This is max_block: " << _Block::max_block << endl;
  cout << "This is _nextblock0_size: " << _nextblock0_size << endl;
  for (int j = 0; j < _nextblock0_size; ++j){
    for (int k = 0; k < n; ++k){
      printf("%d ", (int)_nextBlock0->a[k * _Block::max_block + j]);
    }
    cout << endl;
  }
  cout << endl;
#endif

  *_depth += 1;
  if (_nextblock0_size > 0 && (_nextblock0_size <= _expandSize / numColor || *_depth == g_nnodes )) { //may result in bugs
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
    color_expand_bf(_stack, _depth, num, n);
  } else { //Reach the buffer size, or finish all evaluation
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
  }
}

/*Benchmark entrance called by harness*/
int app_main(int argc, char** argv){
  int numSolution = 0;

  if (argc != 1 && argc != 2){
    printf("Usage: ./graphcoloring [color numbers] or ./graphcoloring [color numbers] [max block size k, in pow(3, k)]\n");
    exit(0);
  }

  numColor = atoi(argv[0]);
  if (argc == 2) _expandSize = pow(2.0, atoi(argv[1]));
  printf("Start %d-Color Process...", numColor);

  /*******Read input data**************/
  int numNode, numEdge;
  int *edge;
  FILE *data;
  char tmp1[50], tmp2[50];
  data = fopen(DATAFILE, "r");
  if(data == NULL) {
    printf("Open data file failed\n");
    exit(0);
  }
  fscanf(data, "%s %s %d %d\n", tmp1, tmp2, &numNode, &numEdge);
  printf("numNode = %d, numEdge =%d\n", numNode, numEdge);

  edge = (int *)malloc(numEdge*sizeof(int)*2);
  readEdge(data, numEdge, numNode, edge);
  fclose(data);
  /********Read input data end**********/

  //Construct adjacent Matrix
  init_graph(numNode, numEdge, edge);
#ifdef _DEBUG
  print_graph(numNode);
#endif
  //Color auxiliary array
  _MM_ALIGNED_ node_t* c = (node_t*)malloc(numNode * sizeof(node_t));
  memset(c, 0, numNode * sizeof(node_t));

  //Start coloring...
  Harness::start_timing();

  //_expandDepth = Harness::get_splice_depth();

  //Initialize software block stack
  g_nnodes = numNode;
  _Block::n = numNode;
  cout << "Set fixed max block buffer size, _expandSize: " << _expandSize << endl;
  _Block::max_block = _expandSize;
  Harness::set_block_size(_expandSize);
  class _BlockStack * _stack = new _BlockStack;
  class _Block * _block = new _Block;
  g_initial_block = _block;

  _block->add(c, 0);
  int _depth = 0;
  _stack->get (_depth) -> block = _block;

  //Start to execute blocked graphcol 
  if (_expandSize >= numColor) color_expand_bf(_stack, &_depth, &numSolution, g_nnodes);
  int df_block_size = _stack->get(_depth)->block->size;
  cout << "This is the max block buffer size for dfs: " << df_block_size << endl;
  cout << "This is the result now: " << numSolution << endl;

  if (df_block_size){
    for (int i = 1; i <= numColor; i++) {
      color_block(_stack, _depth, &numSolution, i, g_nnodes);
    }
  }

  delete _stack;
  if (_expandSize < numColor) delete _block;

  Harness::stop_timing();

#ifdef BLOCK_PROFILE
  profiler.output();
#endif
#ifdef TRACK_TRAVERSALS
  cout << "work: " << work << endl;
#endif

  printf("This is the number of possible solutions: %d\n", numSolution);

#ifdef PROFILE_SPACE_USE
  cout << "This is max space use (Bytes): " << m_space << endl;
  cout << "This is total malloc counts: " << total_malloc << endl;
#endif

  free(edge);
  free(adjacentNodes);

  return 1;
}
