/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Software block stack for MIC                     */
/**********************************************************/

#include <vector>
#include <cassert>

#define _MM_ALIGNED_  __declspec(align(64)) 
#define node_t int 
const int MY_SIMD_WIDTH = 16;

#define D_MAX_BLOCK_SIZE 128
int g_nnodes = 0;

//#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif

using namespace std;

class _InitialPoint {
public:
	node_t *b;
	int _callIndex;

	_InitialPoint(node_t n, node_t *b, int _callIndex);
	~_InitialPoint();
};

_InitialPoint::_InitialPoint(node_t n, node_t *b, int _callIndex) {
	this->b = (node_t *)_mm_malloc(n * sizeof(node_t), 64);
	memcpy(this->b, b, n * sizeof(node_t));
	this->_callIndex = _callIndex;
}

_InitialPoint::~_InitialPoint() {
	_mm_free(b);
}

class _Block {
public:
	_Block();
	~_Block();

	void add(node_t *b, int n);
	void add(_Block *block, long long bi, int n);
	node_t get(int _bi, int n) { return a[n * max_block + _bi]; }
	node_t *getptr(int _bi, int n) { return &a[n * max_block + _bi]; }
	void set(int _bi, int n, int val) { a[n * max_block + _bi] = val; }
	void recycle() { size = 0; }
	bool is_full() { return size == max_block; }
	bool is_empty() { return size == 0; }

    _MM_ALIGNED_ node_t *a;
	long long size;

	static long long max_block;
	static int n; // == numNode
};

class _BlockSet
{
public:
	_BlockSet() {}
	~_BlockSet() {}

	_Block *block;
	_Block nextBlock0;
};

class _BlockStack
{
public:
	_BlockStack() {}
	~_BlockStack();

	_BlockSet* get(int i);

    void release(int _depth){
        delete this->items[_depth];
        this->items[_depth] = NULL;
    }
	vector<_BlockSet *> items;
};

long long _Block::max_block = 128;
int _Block::n; //== numNode

_Block::_Block() {
	a = (node_t *)_mm_malloc(sizeof(node_t) * max_block * n, 64);
	size = 0;
#ifdef PROFILE_SPACE_USE
    c_space += max_block * sizeof(node_t) * n;
    m_space = max(m_space, c_space);
    total_malloc++;
#endif
}

_Block::~_Block() {
    if (a){
	    _mm_free(a);
        a = NULL;
    }
#ifdef PROFILE_SPACE_USE
    c_space -= max_block * sizeof(node_t) * n;
    m_space = max(m_space, c_space);
#endif

}

void _Block::add(node_t *b, int n) {
	assert(size < max_block);
	for (int i = 0; i < n; i++) {
		a[i * max_block + size] = b[i];
	}
	size++;
}

void _Block::add(_Block *block, long long bi, int n) {
	assert(size < max_block);
	for (int i = 0; i < n; i++) {
		a[i * max_block + size] = block->a[i * max_block + bi];
	}
	size++;
}

_BlockStack::~_BlockStack() {
	for (int i = 0; i < items.size(); i++) {
		if(items[i]) delete items[i];
	}
}

_BlockSet* _BlockStack::get(int i) {
	while (i >= items.size()) {
		items.push_back(new _BlockSet());
	}
	return items[i];
}
