/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: MIC block wo reexpansion of fibonacci            */
/**********************************************************/

#include <iostream>
#include <fstream>
#include <math.h>

#include "harness.h"
#include "block-mic.h"
#include "simd.h"

const int MY_SIMD_WIDTH = 16;//Set SIMD width
using namespace std;

_Block * g_initial_block = NULL;//For memory release

/*Pseudo tail recursive fib matching our language spec*/
void fib(int n, int *sum) {
#ifdef BLOCK_PROFILE
  profiler.record_single();
#endif

  if (n == 1 || n == 0) {
    *sum += 1;
  } else {
    fib(n - 1, sum);
    fib(n - 2, sum);
  }
}

//int _expandDepth = 0;
int _expandSize = D_MAX_BLOCK_SIZE;

void fib1(class _BlockStack *_stack,int _depth, int *sum);

/*sequential processing for left children*/
inline void process_point0(_Block *_block, _Block *_nextBlock0, int _bi, int *sum) {
  int n = _block->n0[_bi];
  if (n == 1 || n == 0) {
    *sum += 1;
  } else {
    _nextBlock0->add(n - 1, n - 2);
  }
}

/*simd processing for left children, we store n in int in the block*/
inline void process_simd0_opt(_Block *_block, _Block *_nextBlock0, int _si, int *sum) {
  __m512i vec_n = _mm512_load_epi32((__m512i*)&_block->n0[_si]);
  __m512i vec_1 = _mm512_set1_epi32(1);
  __m512i vec_0 = _mm512_setzero_epi32();

  __mmask16 vec_n_eq_1 = _mm512_cmp_epi32_mask(vec_n, vec_1, _MM_CMPINT_EQ);
  __mmask16 vec_n_eq_0 = _mm512_cmp_epi32_mask(vec_n, vec_0, _MM_CMPINT_EQ);
  __mmask16 mask_is_leaf = _mm512_kor(vec_n_eq_1, vec_n_eq_0);

#ifdef NOSC
  //Sequential Processing
  if (mask_is_leaf & 1){
    *sum += 1;
  } else {
    int n = _block->n0[_si];
    _nextBlock0->add( n - 1, n - 2);
  }

  for (int i = 1; i < MY_SIMD_WIDTH; ++i){
    mask_is_leaf >>= 1;
    if (mask_is_leaf & 1){
      *sum += 1;
    } else {
      int n = _block->n0[_si + i];
      _nextBlock0->add(n - 1, n - 2);
    }
  }

#else // With Stream Compaction

#ifdef SEQSC
  __declspec(align(64)) int tmp[MY_SIMD_WIDTH] = {0};
  __declspec(align(64)) int tmp_non_leaf[MY_SIMD_WIDTH] = {0};
  _mm512_mask_store_epi32(tmp_non_leaf, ~mask_is_leaf, vec_1);

  for (int i = 1; i < MY_SIMD_WIDTH; ++i){
    tmp[i] = tmp[i-1] + tmp_non_leaf[i-1];
  }

  __m512i vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), _mm512_load_epi32(tmp));

  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n0, ~mask_is_leaf, vec_index, vec_n, 4);
  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n1, ~mask_is_leaf, vec_index, vec_n, 4);
  int adv = tmp[MY_SIMD_WIDTH - 1] + tmp_non_leaf[MY_SIMD_WIDTH - 1];
  _nextBlock0->size += adv;
  *sum += 16 - adv;
#else //no SEQSC
  unsigned short low_8, high_8;
  low_8 = (~mask_is_leaf) & 0x00FF;
  high_8 = ((~mask_is_leaf) & 0xFF00) >> 8;

  __m512i vec_index = _mm512_load_epi32(g_scantable[low_8]);
  __m512i vec_index_1 = _mm512_load_epi32(g_scantable[high_8]);

  __m512i vec_index_offset = _mm512_set1_epi32(g_scantable[low_8][7] + (((~mask_is_leaf) >> 7) & 0x1));

  vec_index_1 = _mm512_mask_add_epi32(vec_index_1, 0x00FF, vec_index_1, vec_index_offset);
  vec_index_1 = _mm512_permute4f128_epi32(vec_index_1, _MM_PERM_BADC);
  vec_index = _mm512_and_epi32(vec_index, vec_index_1);

  vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), vec_index);

  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n0, ~mask_is_leaf, vec_index, vec_n, 4);
  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n1, ~mask_is_leaf, vec_index, vec_n, 4);

  int adv = g_scantable[low_8][7] + g_scantable[high_8][7] + (((~mask_is_leaf) >> 7) & 0x1) + (((~mask_is_leaf) >> 15) & 0x1);
  _nextBlock0->size += adv;
  *sum += 16 - adv;

#endif // SEQSC

#endif 	
}

/*Depth First execution of left children to limit the memory consumption*/
void fib0(class _BlockStack *_stack,int _depth, int *sum) {
  class _BlockSet *_set = _stack ->  get (_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();

  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point0(_block, _nextBlock0, _bi, sum);
    }
#else	// not SIMD_NONE
    process_simd0_opt(_block, _nextBlock0, _si, sum);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int valid_mask = get_valid_mask(_si, _block->size);
  if (valid_mask == 1) {
    process_point0(_block, _nextBlock0, _si, sum);
  } else if (valid_mask > 1) {
    process_simd(_block, _nextBlock0, _si, valid_mask);
  }
#else	// not SIMD_ALL
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point0(_block, _nextBlock0, _bi, sum);
  }
#endif

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    fib0(_stack, _depth + 1, sum);
    fib1(_stack, _depth + 1, sum);
  }
}

/*sequential processing for right children*/
inline void process_point1(_Block *_block, _Block *_nextBlock0, int _bi, int *sum) {
  int n = _block->n1[_bi];
  if (n == 1 || n == 0) {
    *sum += 1;
  } else {
    _nextBlock0->add(n - 1, n - 2);
  }
}

/*simd processing for right children, we store n in int in the block*/
inline void process_simd1_opt(_Block *_block, _Block *_nextBlock0, int _si, int *sum) {
  __m512i vec_n = _mm512_load_epi32((__m512i*)&_block->n1[_si]);
  __m512i vec_1 = _mm512_set1_epi32(1);
  __m512i vec_0 = _mm512_setzero_epi32();

  __mmask16 vec_n_eq_1 = _mm512_cmp_epi32_mask(vec_n, vec_1, _MM_CMPINT_EQ);
  __mmask16 vec_n_eq_0 = _mm512_cmp_epi32_mask(vec_n, vec_0, _MM_CMPINT_EQ);
  __mmask16 mask_is_leaf = _mm512_kor(vec_n_eq_1, vec_n_eq_0);

#ifdef NOSC
  //Sequential Processing
  if (mask_is_leaf & 1){
    *sum += 1;
  } else {
    int n = _block->n1[_si];
    _nextBlock0->add( n - 1, n - 2);
  }

  for (int i = 1; i < MY_SIMD_WIDTH; ++i){
    mask_is_leaf >>= 1;
    if (mask_is_leaf & 1){
      *sum += 1;
    } else {
      int n = _block->n1[_si + i];
      _nextBlock0->add(n - 1, n - 2);
    }
  }

#else // With Stream Compaction
#ifdef SEQSC 
  __declspec(align(64)) int tmp[MY_SIMD_WIDTH] = {0};
  __declspec(align(64)) int tmp_non_leaf[MY_SIMD_WIDTH] = {0};
  _mm512_mask_store_epi32(tmp_non_leaf, ~mask_is_leaf, vec_1);

  for (int i = 1; i < MY_SIMD_WIDTH; ++i){
    tmp[i] = tmp[i-1] + tmp_non_leaf[i-1];
  }

  __m512i vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), _mm512_load_epi32(tmp));

  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n0, ~mask_is_leaf, vec_index, vec_n, 4);
  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n1, ~mask_is_leaf, vec_index, vec_n, 4);
  int adv = tmp[MY_SIMD_WIDTH - 1] + tmp_non_leaf[MY_SIMD_WIDTH - 1];
  _nextBlock0->size += adv;
  *sum += 16 - adv;

#else //no SEQSC
  unsigned short low_8, high_8;
  low_8 = (~mask_is_leaf) & 0x00FF;
  high_8 = ((~mask_is_leaf) & 0xFF00) >> 8;

  __m512i vec_index = _mm512_load_epi32(g_scantable[low_8]);
  __m512i vec_index_1 = _mm512_load_epi32(g_scantable[high_8]);

  __m512i vec_index_offset = _mm512_set1_epi32(g_scantable[low_8][7] + (((~mask_is_leaf) >> 7) & 0x1));

  vec_index_1 = _mm512_mask_add_epi32(vec_index_1, 0x00FF, vec_index_1, vec_index_offset);
  vec_index_1 = _mm512_permute4f128_epi32(vec_index_1, _MM_PERM_BADC);
  vec_index = _mm512_and_epi32(vec_index, vec_index_1);

  vec_index = _mm512_add_epi32(_mm512_set1_epi32(_nextBlock0->size), vec_index);

  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n0, ~mask_is_leaf, vec_index, vec_n, 4);
  vec_n = _mm512_sub_epi32(vec_n, vec_1);
  _mm512_mask_i32scatter_epi32((int*)_nextBlock0->n1, ~mask_is_leaf, vec_index, vec_n, 4);

  int adv = g_scantable[low_8][7] + g_scantable[high_8][7] + (((~mask_is_leaf) >> 7) & 0x1) + (((~mask_is_leaf) >> 15) & 0x1);
  _nextBlock0->size += adv;
  *sum += 16 - adv;
#endif // SEQSC

#endif 	
}

/*Depth First execution of right children to limit the memory consumption*/
void fib1(class _BlockStack *_stack,int _depth, int *sum) {
  class _BlockSet *_set = _stack ->  get (_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();

  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point1(_block, _nextBlock0, _bi, sum);
    }
#else	// not SIMD_NONE
    process_simd1_opt(_block, _nextBlock0, _si, sum);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int valid_mask = get_valid_mask(_si, _block->size);
  if (valid_mask == 1) {
    process_point1(_block, _nextBlock0, _si, sum);
  } else if (valid_mask > 1) {
    process_simd(_block, _nextBlock0, _si, valid_mask);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point1(_block, _nextBlock0, _bi, sum);
  }
#endif

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    fib0(_stack, _depth + 1, sum);
    fib1(_stack, _depth + 1, sum);
  }
}


/*Breadth First execution to expand the number of tasks in software block*/
void fib_expand_bf(class _BlockStack *_stack, int *_depth, int *sum){
  class _BlockSet *_set = _stack ->  get (*_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();

  //Add left
  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point0(_block, _nextBlock0, _bi, sum);
    }
#else	// not SIMD_NONE
    process_simd0_opt(_block, _nextBlock0, _si, sum);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int valid_mask = get_valid_mask(_si, _block->size);
  if (valid_mask == 1) {
    process_point0(_block, _nextBlock0, _si, sum);
  } else if (valid_mask > 1) {
    process_simd(_block, _nextBlock0, _si, valid_mask);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point0(_block, _nextBlock0, _bi, sum);
  }
#endif

  //Add right 
  _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point1(_block, _nextBlock0, _bi, sum);
    }
#else	// not SIMD_NONE
    process_simd1_opt(_block, _nextBlock0, _si, sum);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int valid_mask = get_valid_mask(_si, _block->size);
  if (valid_mask == 1) {
    process_point1(_block, _nextBlock0, _si, sum);
  } else if (valid_mask > 1) {
    process_simd(_block, _nextBlock0, _si, valid_mask);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point1(_block, _nextBlock0, _bi, sum);
  }
#endif

  //Free old stack space
  if (!*_depth){
    delete g_initial_block;
  } else
  {
    _stack->release(*_depth - 1);
  }

  int _nextblock0_size = _nextBlock0 -> _Block::size;
  *_depth += 1;
  if (_nextblock0_size > 0 && _nextblock0_size <= _expandSize/2) {
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
    fib_expand_bf(_stack, _depth, sum);
  } else { //Reach the buffer size, or finish all evaluation
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
  }
}

/*Benchmark entrance called by harness*/
int app_main(int argc, char **argv) {
  if (argc != 1 && argc != 2) {
    cout << "usage: fibonacci [n] or fibonacci [n] [buffer_size, pow(2, k)]" << endl;
    exit(1);
  }

  int n = atoi(argv[0]);
  if (argc == 2) _expandSize = pow(2.0, atoi(argv[1]));
  int sum = 0;

  Harness::start_timing();
  //_expandDepth = Harness::get_splice_depth();

  //Initialize software block stack
  cout << "Set fixed max block buffer size, _expandSize: " << _expandSize << endl;
  _Block::max_block = _expandSize;
  Harness::set_block_size(_expandSize);
  class _BlockStack * _stack = new _BlockStack;
  class _Block * _block = new _Block;
  g_initial_block = _block;

  if (n == 0 || n == 1){
    cout << "Please input a larger number rather than 0 or 1 ..." << endl;
    exit(0);
  }

  _block->add(n - 1, n - 2);
  int _depth = 0;
  _stack->get (_depth) -> block = _block;

  //Start to execute blocked fib
  if (_expandSize >= 2) fib_expand_bf(_stack, &_depth, &sum);
  int df_block_size = _stack->get(_depth)->block->size;
  cout << "This is the max block buffer size for dfs: " << df_block_size << endl;

  if (df_block_size){
    fib0(_stack, _depth, &sum);
    fib1(_stack, _depth, &sum);
  }
  delete _stack;
  if (_expandSize < 2) delete _block;

  Harness::stop_timing();

#ifdef BLOCK_PROFILE
  profiler.output();
#endif
  cout << sum << endl;
#ifdef PROFILE_SPACE_USE
  cout << "This is max space use (Bytes): " << m_space << endl;
  cout << "This is total malloc counts: " << total_malloc << endl;
#endif

  return 0;
}

