/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Software block stack for MIC                     */
/**********************************************************/

#include <vector>
#include <cassert>

#define D_MAX_BLOCK_SIZE 128
#define node_t int

//#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif

using namespace std;

class _Point {
 public:
  int n0, n1;
  _Point() {}
  _Point(int n0, int n1);
};

_Point::_Point(int n0, int n1) {
  this->n0 = n0;
  this->n1 = n1;
}

class _Block {
 public:
  _Block();
  ~_Block();

  void add(int n0, int n1);
  void recycle() { size = 0; }
  bool is_full() { return size == max_block; }
  bool is_empty() { return size == 0; }

  __declspec(align(64)) node_t *n0;
  __declspec(align(64)) node_t *n1;

  int size;

  static int max_block;
};

class _BlockSet
{
 public:
  _BlockSet() {}
  ~_BlockSet() {}

  _Block *block;
  _Block nextBlock0;
};

class _BlockStack
{
 public:
  _BlockStack() { }
  ~_BlockStack();

  _BlockSet* get(int i);

  void release(int _depth){
    delete this->items[_depth];
    this->items[_depth] = NULL;
  }
  vector<_BlockSet *> items;
};

int _Block::max_block = 1024;

_Block::_Block() {
  n0 = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);
  n1 = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);

  size = 0;
#ifdef PROFILE_SPACE_USE
  c_space += max_block * sizeof(node_t) * 2;
  m_space = max(m_space, c_space);
  total_malloc++;
#endif
}

_Block::~_Block() {
  _mm_free(n0);
  _mm_free(n1);

#ifdef PROFILE_SPACE_USE
  c_space -= max_block * sizeof(node_t) * 2;
  m_space = max(m_space, c_space);
#endif

}

inline void _Block::add(int n0, int n1) {
  assert(size < max_block);
  this->n0[size] = n0;
  this->n1[size] = n1;
  size++;
}

_BlockStack::~_BlockStack() {
  for (int i = 0; i < items.size(); i++) {
    if (items[i]) delete items[i];
  }
}

inline _BlockSet* _BlockStack::get(int i) {
  while (i >= items.size()) {
    items.push_back(new _BlockSet());
  }

  return items[i];
}


__declspec(align(64)) static const int g_scantable[256][16] = {
  0,  0,  0,  0,  0,  0,  0,  0,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  6,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  0,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  6,  7,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  0,  0,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  6,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  0,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  0,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  0,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  0,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  0,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  0,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
  0,  1,  2,  3,  4,  5,  6,  7,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF 
};


