/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: Software block stack for MIC                     */
/**********************************************************/

#include <inttypes.h>
#include <vector>
#include <cassert>

#define D_MAX_BLOCK_SIZE 1024
#define node_t int

#define PROFILE_SPACE_USE

#ifdef PROFILE_SPACE_USE
long long m_space = 0;
long long c_space = 0;
long long total_malloc = 0;
#endif


using namespace std;

class _Point {
public:
	node_t n, k;
	_Point() {}
	_Point(node_t n, node_t k) {
		this->n = n;
		this->k = k;
	}
};

class _Block {
public:
	_Block();
	~_Block();

	void add(node_t n, node_t k);
	void add(_Block *block, int bi);
	void add1(_Block *block, int bi);
	void recycle() { size = 0; }
	bool is_full() { return size == max_block; }
	bool is_empty() { return size == 0; }

//	__attribute__((aligned(16))) node_t *n;
 //   __attribute__((aligned(16))) node_t *k;
	__declspec(align(64)) node_t *n;
	__declspec(align(64)) node_t *k;

	int size;

	static long long max_block;
};

class _BlockSet
{
public:
	_BlockSet() {}
	~_BlockSet() {}

	_Block *block;
	_Block nextBlock0;
};

class _BlockStack
{
public:
	_BlockStack() {}
	~_BlockStack();

	_BlockSet* get(int i);

    void release(int _depth){
        delete this->items[_depth];
        this->items[_depth] = NULL;
    }
	vector<_BlockSet *> items;
};

long long  _Block::max_block = 128;

_Block::_Block() {
	//    n = new node_t[max_block];
	//    k = new node_t[max_block];
	n = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);
	k = (node_t *)_mm_malloc(max_block * sizeof(node_t), 64);

	size = 0;
#ifdef PROFILE_SPACE_USE
	c_space += max_block * sizeof(node_t) * 2;
	m_space = max(m_space, c_space);
	total_malloc++;
#endif
}

_Block::~_Block() {
//	delete [] n;
//	delete [] k;
	_mm_free(n);
	_mm_free(k);

#ifdef PROFILE_SPACE_USE
    c_space -= max_block * sizeof(node_t) * 2;
    m_space = max(m_space, c_space);
#endif
}

void _Block::add(node_t n, node_t k) {
	assert(size < max_block);
	this->n[size] = n;
	this->k[size] = k;
	size++;
}

void _Block::add(_Block *block, int bi) {
	assert(size < max_block);
	n[size] = block->n[bi] - 1;
	k[size] = block->k[bi];
	size++;
}

void _Block::add1(_Block *block, int bi) {
	assert(size < max_block);
	n[size] = block->n[bi] - 1;
	k[size] = block->k[bi] - 1;
	size++;
}

_BlockStack::~_BlockStack() {
	for (int i = 0; i < items.size(); i++) {
		if (items[i]) delete items[i];
	}
}

_BlockSet* _BlockStack::get(int i) {
	while (i >= items.size()) {
		items.push_back(new _BlockSet());
	}
	return items[i];
}

__declspec(align(64)) static const int g_scantable[256][16] = {
0,  0,  0,  0,  0,  0,  0,  0,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  0,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  7,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  0,  0,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  0,  1,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  0,  1,  2,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  0,  1,  2,  3,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  0,  1,  2,  3,  4,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  0,  1,  2,  3,  4,  5,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  0,  1,  2,  3,  4,  5,  6,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF, 
0,  1,  2,  3,  4,  5,  6,  7,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF,  0xF 
};


