/**********************************************************/
/* This code is for PLDI-15 Artifact Evaluation only      */ 
/* and will be released with further copyright information*/ 
/* File: SSE4 block wo reexpansion of binomial            */
/**********************************************************/

#include <math.h>
#include <iostream>
#include <fstream>

#include "harness.h"
#include "block-sse.h"
#include "simd.h"

#ifdef BLOCK_PROFILE
#include "blockprofiler.h"
BlockProfiler profiler;
#endif

using namespace std;

const int MY_SIMD_WIDTH = 16;//Set SIMD width

_Block * g_initial_block = NULL;//For memory release

/*Pseudo tail recursive binomial matching our language spec*/
void binomial(char n, char k, int *num) {
#ifdef BLOCK_PROFILE
  profiler.record_single();
#endif

  if (k == 0 || k == n) {
    *num += 1;
  } else if (k < 0 || k > n) {
  } else {
    binomial(n-1, k-1, num);
    binomial(n-1, k, num);
  }
}

//int _expandDepth = 0;
long long _expandSize = D_MAX_BLOCK_SIZE;

/*sequential processing for left children*/
inline void process_point(_Block *_block, _Block *_nextBlock0, int _bi, int *num) {
  char n = _block->n[_bi];
  char k = _block->k[_bi];
  if (k == 0 || k == n) {
    *num += 1;
  } else if (k < 0 || k > n) {
  } else {
    _nextBlock0->add(_block, _bi);
  }
}

/*simd processing for left children, we store n in char in the block*/
#ifdef NOSC
inline void process_simd_opt(_Block *_block, _Block *_nextBlock0, int _si, int *num, int rem_work = MY_SIMD_WIDTH) {
  __m128i vec_n = _mm_load_si128((__m128i*)&_block->n[_si]);
  __m128i vec_k = _mm_load_si128((__m128i*)&_block->k[_si]);
  __m128i vec_0 = _mm_setzero_si128();
  __m128i vec_k_eq_0 = _mm_cmpeq_epi8(vec_k, vec_0);
  __m128i vec_k_eq_n = _mm_cmpeq_epi8(vec_k, vec_n);
  __m128i vec_cond1 = _mm_or_si128(vec_k_eq_0, vec_k_eq_n);
  __m128i vec_k_lt_0 = _mm_cmplt_epi8(vec_k, vec_0);
  __m128i vec_k_gt_n = _mm_cmpgt_epi8(vec_k, vec_n);
  __m128i vec_cond2 = _mm_or_si128(vec_k_lt_0, vec_k_gt_n);
  int mask1 = _mm_movemask_epi8(vec_cond1);
  int mask2 = _mm_movemask_epi8(vec_cond2);

  for (int i = 0; i < rem_work; i++) {
    int f = 1 << i;
    if (f & mask1) {
      *num += 1;
    } else if (f & mask2) {
    } else {
      _nextBlock0->add(_block, _si + i); // includes n-1
    }
  }
}

#else

inline void process_simd_opt(_Block *_block, _Block *_nextBlock0, int _si, int *num, int rem_work = MY_SIMD_WIDTH) {
  __m128i vec_n = _mm_load_si128((__m128i*)&_block->n[_si]);
  __m128i vec_k = _mm_load_si128((__m128i*)&_block->k[_si]);
  __m128i vec_0 = _mm_setzero_si128();
  __m128i vec_k_eq_0 = _mm_cmpeq_epi8(vec_k, vec_0);
  __m128i vec_k_eq_n = _mm_cmpeq_epi8(vec_k, vec_n);
  __m128i vec_cond1 = _mm_or_si128(vec_k_eq_0, vec_k_eq_n);
  __m128i vec_k_lt_0 = _mm_cmplt_epi8(vec_k, vec_0);
  __m128i vec_k_gt_n = _mm_cmpgt_epi8(vec_k, vec_n);
  __m128i vec_cond2 = _mm_or_si128(vec_k_lt_0, vec_k_gt_n);
  __m128i vec_cond1_or_cond2 = _mm_or_si128(vec_cond1, vec_cond2);

  int mask1 = _mm_movemask_epi8(vec_cond1);
  int mask2 = _mm_movemask_epi8(vec_cond1_or_cond2);

  vec_n = _mm_sub_epi8(vec_n, _mm_set1_epi8(1));

  __attribute__((aligned(16))) unsigned char tmp[16];
  unsigned index = 0;
  //do first 8
  *((__int64*)tmp) = g_shuffletable[mask2 & 0x000000FF];
  index += g_advanceNextPtrCounts[mask2 & 0x000000FF];
  // now second 8
  *((__int64*)&tmp[index]) = 0x0808080808080808 + g_shuffletable[(mask2 & 0x0000FF00) >> 8];
  index += g_advanceNextPtrCounts[(mask2 & 0x0000FF00) >> 8];
  // fill rest with 0xFF
  memset(&tmp[index], 0xFF, 16 - index);

  __m128i vec_shuffleTable =  _mm_load_si128((const __m128i *) tmp);
  vec_n = _mm_shuffle_epi8(vec_n, vec_shuffleTable);
  vec_k = _mm_shuffle_epi8(vec_k, vec_shuffleTable);

  assert(_nextBlock0->size < _nextBlock0->max_block);
  _mm_storeu_si128((__m128i*)&_nextBlock0->n[_nextBlock0->size], vec_n);
  _mm_storeu_si128((__m128i*)&_nextBlock0->k[_nextBlock0->size], vec_k);

  _nextBlock0->size += index;
  *num = *num + 16 - (g_advanceNextPtrCounts[mask1 & 0x000000FF] + g_advanceNextPtrCounts[(mask1 & 0x0000FF00) >> 8]);
}
#endif


void binomial_block1(class _BlockStack *_stack,int _depth, int *num);

/*Depth First execution of left children to limit the memory consumption*/
void binomial_block(class _BlockStack *_stack,int _depth, int *num) {
  class _BlockSet *_set = _stack ->  get (_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, _depth);
#endif

  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point(_block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd_opt(_block, _nextBlock0, _si, num);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int rem_work = _block->size - _si;
  if (rem_work == 1) {
    process_point(_block, _nextBlock0, _si, num);
  } else if (rem_work > 1) {
    process_simd_opt(_block, _nextBlock0, _si, num, rem_work);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point(_block, _nextBlock0, _bi, num);
  }
#endif

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    binomial_block1(_stack, _depth + 1, num);
    binomial_block(_stack, _depth + 1, num);

  }
}

/*sequential processing for right children*/
inline void process_point1(_Block *_block, _Block *_nextBlock0, int _bi, int *num) {
  char n = _block->n[_bi];
  char k = _block->k[_bi] - 1;
  if (k == 0 || k == n) {
    *num += 1;
  } else if (k < 0 || k > n) {
  } else {
    _nextBlock0->add1(_block, _bi);
  }
}

/*simd processing for right children, we store n in char in the block*/
#ifdef NOSC
inline void process_simd1(_Block *_block, _Block *_nextBlock0, int _si, int *num, int rem_work = MY_SIMD_WIDTH) {
  __m128i vec_n = _mm_loadu_si128((__m128i*)&_block->n[_si]);
  __m128i vec_k = _mm_loadu_si128((__m128i*)&_block->k[_si]);
  __m128i vec_0 = _mm_setzero_si128();
  __m128i vec_1 = _mm_set1_epi8(1);
  vec_k = _mm_sub_epi8(vec_k, vec_1);
  __m128i vec_k_eq_0 = _mm_cmpeq_epi8(vec_k, vec_0);
  __m128i vec_k_eq_n = _mm_cmpeq_epi8(vec_k, vec_n);
  __m128i vec_cond1 = _mm_or_si128(vec_k_eq_0, vec_k_eq_n);
  __m128i vec_k_lt_0 = _mm_cmplt_epi8(vec_k, vec_0);
  __m128i vec_k_gt_n = _mm_cmpgt_epi8(vec_k, vec_n);
  __m128i vec_cond2 = _mm_or_si128(vec_k_lt_0, vec_k_gt_n);
  int mask1 = _mm_movemask_epi8(vec_cond1);
  int mask2 = _mm_movemask_epi8(vec_cond2);

  for (int i = 0; i < rem_work; i++) {
    int f = 1 << i;
    if (f & mask1) {
      *num += 1;
    } else if (f & mask2) {
    } else {
      _nextBlock0->add1(_block, _si + i); // includes n-1
    }
  }
}
#else

inline void process_simd1_opt(_Block *_block, _Block *_nextBlock0, int _si, int *num, int rem_work = MY_SIMD_WIDTH) {
  __m128i vec_n = _mm_load_si128((__m128i*)&_block->n[_si]);
  __m128i vec_k = _mm_load_si128((__m128i*)&_block->k[_si]);
  __m128i vec_0 = _mm_setzero_si128();
  __m128i vec_1 = _mm_set1_epi8(1);
  vec_k = _mm_sub_epi8(vec_k, vec_1);
  __m128i vec_k_eq_0 = _mm_cmpeq_epi8(vec_k, vec_0);
  __m128i vec_k_eq_n = _mm_cmpeq_epi8(vec_k, vec_n);
  __m128i vec_cond1 = _mm_or_si128(vec_k_eq_0, vec_k_eq_n);
  __m128i vec_k_lt_0 = _mm_cmplt_epi8(vec_k, vec_0);
  __m128i vec_k_gt_n = _mm_cmpgt_epi8(vec_k, vec_n);
  __m128i vec_cond2 = _mm_or_si128(vec_k_lt_0, vec_k_gt_n);
  __m128i vec_cond1_or_cond2 = _mm_or_si128(vec_cond1, vec_cond2);

  int mask1 = _mm_movemask_epi8(vec_cond1);
  int mask2 = _mm_movemask_epi8(vec_cond1_or_cond2);

  vec_n = _mm_sub_epi8(vec_n, vec_1);

  __attribute__((aligned(16))) unsigned char tmp[16];
  unsigned index = 0;
  //do first 8
  *((__int64*)tmp) = g_shuffletable[mask2 & 0x000000FF];
  index += g_advanceNextPtrCounts[mask2 & 0x000000FF];
  // now second 8
  *((__int64*)&tmp[index]) = 0x0808080808080808 + g_shuffletable[(mask2 & 0x0000FF00) >> 8];
  index += g_advanceNextPtrCounts[(mask2 & 0x0000FF00) >> 8];
  // fill rest with 0xFF
  memset(&tmp[index], 0xFF, 16 - index);

  __m128i vec_shuffleTable =  _mm_load_si128((const __m128i *) tmp);
  vec_n = _mm_shuffle_epi8(vec_n, vec_shuffleTable);
  vec_k = _mm_shuffle_epi8(vec_k, vec_shuffleTable);

  assert(_nextBlock0->size < _nextBlock0->max_block);
  _mm_storeu_si128((__m128i*)&_nextBlock0->n[_nextBlock0->size], vec_n);
  _mm_storeu_si128((__m128i*)&_nextBlock0->k[_nextBlock0->size], vec_k);

  _nextBlock0->size += index;
  *num = *num + 16 - (g_advanceNextPtrCounts[mask1 & 0x000000FF] + g_advanceNextPtrCounts[(mask1 & 0x0000FF00) >> 8]);
}
#endif


/*Depth First execution of right children to limit the memory consumption*/
void binomial_block1(class _BlockStack *_stack,int _depth, int *num) {
  class _BlockSet *_set = _stack ->  get (_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, _depth);
#endif

  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point1(_block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd1_opt(_block, _nextBlock0, _si, num, MY_SIMD_WIDTH);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int rem_work = _block->size - _si;
  if (rem_work == 1) {
    process_point1(_block, _nextBlock0, _si, num);
  } else if (rem_work > 1) {
    process_simd1_opt(_block, _nextBlock0, _si, num, rem_work);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point1(_block, _nextBlock0, _bi, num);
  }
#endif

  if (_nextBlock0 -> _Block::size > 0) {
    _stack ->  get (_depth + 1) -> _BlockSet::block = _nextBlock0;
    binomial_block1(_stack, _depth + 1, num);
    binomial_block(_stack, _depth + 1, num);
  }
}


/*Breadth First execution to expand the number of tasks in software block*/
void binomial_expand_bf(class _BlockStack *_stack, int* _depth, int *num) {
  class _BlockSet *_set = _stack ->  get (*_depth);
  class _Block *_block = _set -> block;
  class _Block *_nextBlock0 = &_set -> _BlockSet::nextBlock0;
  _nextBlock0 ->  recycle ();
#ifdef BLOCK_PROFILE
  profiler.record(_block->size, _depth);
#endif

  //Add Left
  int _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point(_block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd_opt(_block, _nextBlock0, _si, num);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  int rem_work = _block->size - _si;
  if (rem_work == 1) {
    process_point(_block, _nextBlock0, _si, num);
  } else if (rem_work > 1) {
    process_simd_opt(_block, _nextBlock0, _si, num, rem_work);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point(_block, _nextBlock0, _bi, num);
  }
#endif

  //Add Right
  _si = 0;
  for (; _si < (_block->size - MY_SIMD_WIDTH + 1); _si += MY_SIMD_WIDTH) {
#ifdef SIMD_NONE
    for (int _bi = _si; _bi < _si + MY_SIMD_WIDTH; _bi++) {
      process_point1(_block, _nextBlock0, _bi, num);
    }
#else	// not SIMD_NONE
    process_simd1_opt(_block, _nextBlock0, _si, num, MY_SIMD_WIDTH);
#endif // ifdef SIMD_NONE else
  }

#ifdef SIMD_ALL
  rem_work = _block->size - _si;
  if (rem_work == 1) {
    process_point1(_block, _nextBlock0, _si, num);
  } else if (rem_work > 1) {
    process_simd1_opt(_block, _nextBlock0, _si, num, rem_work);
  }
#else	// not SIMD_ALL
  //cleanup code for stripmined loop
  for (int _bi = _si; _bi < _block->size; _bi++) {
    process_point1(_block, _nextBlock0, _bi, num);
  }
#endif

  //Free old stack space
  if (!*_depth){
    delete g_initial_block;
  } else
  {
    _stack->release(*_depth - 1);
  }

  int _nextblock0_size = _nextBlock0 -> _Block::size;
  *_depth += 1;
  if (_nextblock0_size > 0 && _nextblock0_size <= _expandSize / 2) {
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
    binomial_expand_bf(_stack, _depth, num);
  } else { //Reach the buffer size, or finish all evaluation
    _stack ->  get (*_depth) -> _BlockSet::block = _nextBlock0;
  }

}

/*Benchmark entrance called by harness*/
int app_main(int argc, char **argv) {
  if (argc != 2 && argc != 3) {
    cout << "usage: binomial [n] [k] or binomial [n] [k] [buffer_size, pow(2, i)]" << endl;
    exit(0);
  }

  char n = atoi(argv[0]);
  char k = atoi(argv[1]);
  if (argc == 3) _expandSize = pow(2.0, atoi(argv[2]));
  int num = 0;

  Harness::start_timing();

  //_expandDepth = Harness::get_splice_depth();

  //Initialize software block stack
  cout << "Set fixed max block buffer size, _expandSize: " << _expandSize << endl;
  _Block::max_block = _expandSize;
  Harness::set_block_size(_expandSize);
  class _BlockStack * _stack = new _BlockStack;
  class _Block * _block = new _Block;
  g_initial_block = _block;

  if (k == 0 || k == n) {
    num += 1;
  } else if (k < 0 || k > n) {
    return 1;
  } else {
    _block->add(n - 1, k);
  }

  int _depth = 0;
  _stack->get (_depth) -> block = _block;

  //Start to execute blocked binomial 
  if (_expandSize >= 2) binomial_expand_bf(_stack, &_depth, &num);
  int df_block_size = _stack->get(_depth)->block->size;
  cout << "This is the max block buffer size for dfs: " << df_block_size << endl;

  if (df_block_size){
    binomial_block1(_stack, _depth, &num);
    binomial_block(_stack, _depth, &num);
  }

  delete _stack;
  if (_expandSize < 2) delete _block;

  cout << num << endl;

  Harness::stop_timing();

#ifdef BLOCK_PROFILE
  profiler.output();
#endif

#ifdef PROFILE_SPACE_USE
  cout << "This is max space use (Bytes): " << m_space << endl;
  cout << "This is total malloc counts: " << total_malloc << endl;
#endif


  return 0;
}
