/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl;

public class DualPivotQuicksort {
    public static void sort(int[] a) {
        DualPivotQuicksort.sort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        DualPivotQuicksort.rangeCheck(a.length, fromIndex, toIndex);
        DualPivotQuicksort.dualPivotQuicksort(a, fromIndex, toIndex - 1, 3);
    }

    private static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static void swap(int[] a, int i, int j) {
        int temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    private static void dualPivotQuicksort(int[] a, int left, int right, int div) {
        int len = right - left;
        if (len < 27) {
            for (int i = left + 1; i <= right; ++i) {
                for (int j = i; j > left && a[j] < a[j - 1]; --j) {
                    DualPivotQuicksort.swap(a, j, j - 1);
                }
            }
            return;
        }
        int third = len / div;
        int m1 = left + third;
        int m2 = right - third;
        if (m1 <= left) {
            m1 = left + 1;
        }
        if (m2 >= right) {
            m2 = right - 1;
        }
        if (a[m1] < a[m2]) {
            DualPivotQuicksort.swap(a, m1, left);
            DualPivotQuicksort.swap(a, m2, right);
        } else {
            DualPivotQuicksort.swap(a, m1, right);
            DualPivotQuicksort.swap(a, m2, left);
        }
        int pivot1 = a[left];
        int pivot2 = a[right];
        int less = left + 1;
        int great = right - 1;
        for (int k = less; k <= great; ++k) {
            if (a[k] < pivot1) {
                DualPivotQuicksort.swap(a, k, less++);
                continue;
            }
            if (a[k] <= pivot2) continue;
            while (k < great && a[great] > pivot2) {
                --great;
            }
            DualPivotQuicksort.swap(a, k, great--);
            if (a[k] >= pivot1) continue;
            DualPivotQuicksort.swap(a, k, less++);
        }
        int dist = great - less;
        if (dist < 13) {
            ++div;
        }
        DualPivotQuicksort.swap(a, less - 1, left);
        DualPivotQuicksort.swap(a, great + 1, right);
        DualPivotQuicksort.dualPivotQuicksort(a, left, less - 2, div);
        DualPivotQuicksort.dualPivotQuicksort(a, great + 2, right, div);
        if (dist > len - 13 && pivot1 != pivot2) {
            for (int k = less; k <= great; ++k) {
                if (a[k] == pivot1) {
                    DualPivotQuicksort.swap(a, k, less++);
                    continue;
                }
                if (a[k] != pivot2) continue;
                DualPivotQuicksort.swap(a, k, great--);
                if (a[k] != pivot1) continue;
                DualPivotQuicksort.swap(a, k, less++);
            }
        }
        if (pivot1 < pivot2) {
            DualPivotQuicksort.dualPivotQuicksort(a, less, great, div);
        }
    }
}

