/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.jogamp.common.nio.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

public class Line {
    private Point3f source = new Point3f();
    private Point3f target = new Point3f();
    private Color3f color = new Color3f();
    private int maxWidth;
    private int maxHeight;
    private FloatBuffer data = Buffers.newDirectFloatBuffer((int)4);
    private IntBuffer indices = Buffers.newDirectIntBuffer((int)2);
    private float lineWidth = 1.0f;

    public Line(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.update();
        this.indices.rewind();
        this.indices.put(0);
        this.indices.put(1);
        this.color.x = (float)Math.random();
        this.color.y = (float)Math.random();
        this.color.z = (float)Math.random();
        double val = Math.random();
        if (val > 0.9) {
            this.lineWidth = 4.0f;
        } else if (val > 0.8) {
            this.lineWidth = 6.0f;
        }
    }

    public float getWidth() {
        return this.lineWidth;
    }

    public void update() {
        this.source.x = (float)((double)this.maxWidth * Math.random());
        this.source.y = (float)((double)this.maxHeight * Math.random());
        this.target.x = (float)((double)this.maxWidth * Math.random());
        this.target.y = (float)((double)this.maxHeight * Math.random());
    }

    public void draw(GL2 gl) {
        gl.glColor3f(this.color.x, this.color.y, this.color.z);
        gl.glBegin(1);
        gl.glVertex2f(this.source.x, this.source.y);
        gl.glVertex2f(this.target.x, this.target.y);
        gl.glEnd();
    }

    public void vboDraw(GL2 gl, ByteBuffer buf) {
        buf.putFloat(this.source.x);
        buf.putFloat(this.source.y);
        buf.putFloat(this.color.x);
        buf.putFloat(this.color.y);
        buf.putFloat(this.color.z);
        buf.putFloat(this.target.x);
        buf.putFloat(this.target.y);
        buf.putFloat(this.color.x);
        buf.putFloat(this.color.y);
        buf.putFloat(this.color.z);
    }

    public void vboDraw(GL2 gl, int index) {
        this.data.rewind();
        this.data.put(this.source.x);
        this.data.put(this.source.y);
        this.data.put(this.target.x);
        this.data.put(this.target.y);
        this.data.rewind();
        gl.glBufferSubData(34962, (long)(index * 4), (long)(index + 16), (Buffer)this.data);
    }
}

