/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.util;

import com.jogamp.common.nio.Buffers;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.gl2.GLUgl2;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.picking.Box;
import saf.v3d.scene.VSpatial;

public class Utils3D {
    private static final float K_EPSILON = 1.0E-6f;
    private static final float NE_SIN = (float)Math.sin(Math.toRadians(45.0));
    private static final float NE_COS = (float)Math.cos(Math.toRadians(45.0));

    public static void colorToFloats(float[] array, Color color) {
        array[0] = (float)color.getRed() / 255.0f;
        array[1] = (float)color.getGreen() / 255.0f;
        array[2] = (float)color.getBlue() / 255.0f;
        array[3] = (float)color.getAlpha() / 255.0f;
    }

    public static void matrixToBuff(Matrix4f matrix, FloatBuffer buf) {
        buf.rewind();
        buf.put(matrix.m00);
        buf.put(matrix.m10);
        buf.put(matrix.m20);
        buf.put(matrix.m30);
        buf.put(matrix.m01);
        buf.put(matrix.m11);
        buf.put(matrix.m21);
        buf.put(matrix.m31);
        buf.put(matrix.m02);
        buf.put(matrix.m12);
        buf.put(matrix.m22);
        buf.put(matrix.m32);
        buf.put(matrix.m03);
        buf.put(matrix.m13);
        buf.put(matrix.m23);
        buf.put(matrix.m33);
        buf.rewind();
    }

    public static boolean isZero(float val) {
        return Math.abs(val) < 1.0E-6f;
    }

    public static Color floatToColor(float[] color) {
        return new Color(color[0], color[1], color[2], color[3]);
    }

    public static Tuple3f mult(Quat4f rotation, Tuple3f in, Tuple3f out) {
        if (out == null) {
            out = new Vector3f();
        }
        float w = rotation.w;
        float x = rotation.x;
        float y = rotation.y;
        float z = rotation.z;
        float pMult = w * w - x * x - y * y - z * z;
        float vMult = 2.0f * (x * in.x + y * in.y + z * in.z);
        float crossMult = 2.0f * w;
        out.set(pMult * in.x + vMult * x + crossMult * (y * in.z - z * in.y), pMult * in.y + vMult * y + crossMult * (z * in.x - x * in.z), pMult * in.z + vMult * z + crossMult * (x * in.y - y * in.x));
        return out;
    }

    public static Point3f getRelativeLocation(VSpatial item, Location location) {
        BoundingSphere sphere = item.getLocalBoundingSphere();
        Point3f pt = new Point3f(sphere.getCenterRef());
        float radius = sphere.getRadius();
        if (location == Location.NORTH_EAST) {
            float x = radius * NE_SIN;
            float y = radius * NE_COS;
            pt.x += x;
            pt.y += y;
            return pt;
        }
        return null;
    }

    public static float distanceSquared(Point3f pt, Point3f origin, Point3f end) {
        Vector3f dir = new Vector3f((Tuple3f)end);
        dir.sub((Tuple3f)origin);
        Vector3f w = new Vector3f();
        w.sub((Tuple3f)pt, (Tuple3f)origin);
        float proj = w.dot(dir);
        if (proj <= 0.0f) {
            return w.dot(w);
        }
        float vsq = dir.dot(dir);
        if (proj >= vsq) {
            return w.dot(w) - 2.0f * proj + vsq;
        }
        return w.dot(w) - proj * proj / vsq;
    }

    public static BoundingSphere createBoundingSphere(FloatBuffer buf) {
        buf.rewind();
        float[] vertex = new float[3];
        buf.get(vertex);
        Point3f min = new Point3f(vertex);
        Point3f max = new Point3f(vertex);
        while (buf.hasRemaining()) {
            buf.get(vertex);
            float x = vertex[0];
            float y = vertex[1];
            float z = vertex[2];
            if (min.x > x) {
                min.x = x;
            } else if (max.x < x) {
                max.x = x;
            }
            if (min.y > y) {
                min.y = y;
            } else if (max.y < y) {
                max.y = y;
            }
            if (min.z > z) {
                min.z = z;
                continue;
            }
            if (!(max.z < z)) continue;
            max.z = z;
        }
        Point3f center = new Point3f(min);
        center.add((Tuple3f)max);
        center.scale(0.5f);
        buf.rewind();
        buf.get(vertex);
        Point3f pt = new Point3f(vertex);
        float maxDist = center.distanceSquared(pt);
        while (buf.hasRemaining()) {
            buf.get(vertex);
            pt.set(vertex);
            float dist = center.distanceSquared(pt);
            if (!(dist > maxDist)) continue;
            maxDist = dist;
        }
        buf.rewind();
        return new BoundingSphere(center, (float)Math.sqrt(maxDist));
    }

    public static boolean triangleIntersect(Point3f pt, Point3f t1, Point3f t2, Point3f t3) {
        Vector3f v0 = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        v0.sub((Tuple3f)t3, (Tuple3f)t1);
        v1.sub((Tuple3f)t2, (Tuple3f)t1);
        v2.sub((Tuple3f)pt, (Tuple3f)t1);
        float dot00 = v0.dot(v0);
        float dot01 = v0.dot(v1);
        float dot02 = v0.dot(v2);
        float dot11 = v1.dot(v1);
        float dot12 = v1.dot(v2);
        float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
        float u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u > 0.0f && v > 0.0f && u + v < 1.0f;
    }

    public static boolean triangleIntersect(Point3f p0, Point3f p1, Point3f p2, Point3f rayOrigin, Vector3f rayDirection) {
        Vector3f e1 = new Vector3f();
        e1.sub((Tuple3f)p1, (Tuple3f)p0);
        Vector3f e2 = new Vector3f();
        e2.sub((Tuple3f)p2, (Tuple3f)p0);
        Vector3f p = new Vector3f();
        p.cross(rayDirection, e2);
        float a = e1.dot(p);
        if (Utils3D.isZero(a)) {
            return false;
        }
        float f = 1.0f / a;
        Vector3f s = new Vector3f();
        s.sub((Tuple3f)rayOrigin, (Tuple3f)p0);
        float u = f * s.dot(p);
        if (u < 0.0f || u > 1.0f) {
            return false;
        }
        Vector3f q = new Vector3f();
        q.cross(s, e1);
        float v = f * rayDirection.dot(q);
        if (v < 0.0f || u + v > 1.0f) {
            return false;
        }
        float t = f * e2.dot(q);
        return t >= 0.0f;
    }

    public static void triangleNormal(Point3f pt1, Point3f pt2, Point3f pt3, Vector3f result) {
        result.set((Tuple3f)pt2);
        result.sub((Tuple3f)pt1);
        Vector3f v2 = new Vector3f((Tuple3f)pt3);
        v2.sub((Tuple3f)pt2);
        result.cross(result, v2);
        result.normalize();
    }

    public static BoundingSphere createBoundingSphere(Rectangle2D rect) {
        Point3f center = new Point3f((float)rect.getCenterX(), (float)rect.getCenterY(), 0.0f);
        double xExtent = rect.getWidth();
        double yExtent = rect.getHeight();
        float radius = (float)(Math.sqrt(xExtent * xExtent + yExtent * yExtent) / 2.0);
        return new BoundingSphere(center, radius);
    }

    public static Box getWorldSizeAtZ(GL2 gl, float nearClipZ, float farClipZ, float z) {
        IntBuffer viewport = Buffers.newDirectIntBuffer((int)4);
        DoubleBuffer mvMatrix = Buffers.newDirectDoubleBuffer((int)16);
        DoubleBuffer projMatrix = Buffers.newDirectDoubleBuffer((int)16);
        DoubleBuffer output = Buffers.newDirectDoubleBuffer((int)3);
        GLUgl2 glu = new GLUgl2();
        gl.glGetIntegerv(2978, viewport);
        gl.glGetDoublev(2982, mvMatrix);
        gl.glGetDoublev(2983, projMatrix);
        glu.gluUnProject(0.0, 0.0, 0.0, mvMatrix, projMatrix, viewport, output);
        Point3f nearLower = new Point3f();
        nearLower.x = (float)output.get(0);
        nearLower.y = (float)output.get(1);
        nearLower.z = (float)output.get(2);
        glu.gluUnProject((double)viewport.get(2), (double)viewport.get(3), 0.0, mvMatrix, projMatrix, viewport, output);
        Point3f nearUpper = new Point3f();
        nearUpper.x = (float)output.get(0);
        nearUpper.y = (float)output.get(1);
        nearUpper.z = (float)output.get(2);
        glu.gluUnProject(0.0, 0.0, 1.0, mvMatrix, projMatrix, viewport, output);
        Point3f farLower = new Point3f();
        farLower.x = (float)output.get(0);
        farLower.y = (float)output.get(1);
        farLower.z = (float)output.get(2);
        glu.gluUnProject((double)viewport.get(2), (double)viewport.get(3), 1.0, mvMatrix, projMatrix, viewport, output);
        Point3f farUpper = new Point3f();
        farUpper.x = (float)output.get(0);
        farUpper.y = (float)output.get(1);
        farUpper.z = (float)output.get(2);
        float interval = (nearClipZ - z) / Math.abs(farClipZ - nearClipZ);
        Vector3f dir = new Vector3f((Tuple3f)farLower);
        dir.sub((Tuple3f)nearLower);
        Point3f lower = new Point3f();
        lower.x = nearLower.x + dir.x * interval;
        lower.y = nearLower.y + dir.y * interval;
        lower.z = z;
        dir.set((Tuple3f)farUpper);
        dir.sub((Tuple3f)nearUpper);
        Point3f upper = new Point3f();
        upper.x = nearUpper.x + dir.x * interval;
        upper.y = nearUpper.y + dir.y * interval;
        upper.z = z;
        return new Box(lower, upper);
    }

    public static enum Location {
        NORTH_EAST;

    }
}

