/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.awt.Color;
import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.AppearanceFactory;
import saf.v3d.render.BorderRenderer;
import saf.v3d.render.DefaultBorderRenderer;
import saf.v3d.render.NullBorderRenderer;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;
import saf.v3d.scene.VGeometry;
import saf.v3d.scene.VSpatial;

public class VShape
extends VGeometry {
    protected Shape shape;
    private BorderRenderer border = new NullBorderRenderer();

    public VShape(Shape shape, boolean colorUpdatable) {
        this(shape);
        if (!colorUpdatable) {
            this.appSetter = new VSpatial.OneTimeAppSetter(this);
        }
    }

    public VShape(Shape shape) {
        this.shape = shape;
        this.boundingSphere = shape.getLocalBounds();
    }

    @Override
    protected boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        return this.shape.intersects(rayOrigin, rayDirection);
    }

    @Override
    protected boolean intersects(Point3f point) {
        return this.shape.intersects(point);
    }

    @Override
    protected void doDraw(GL2 gl, RenderState state) {
        state.border = this.border;
        this.shape.render(gl, state);
    }

    public void setBorderColor(Color color) {
        if (this.border.getStrokeSize() == -1) {
            this.border = new DefaultBorderRenderer();
        }
        this.border.setColor(AppearanceFactory.createColorAppearance(color));
    }

    public Color getBorderColor() {
        return this.border.getColor().getColor();
    }

    public int getBorderStrokeSize() {
        return this.border.getStrokeSize();
    }

    public void setBorderStrokeSize(int size) {
        if (size == 0) {
            this.border = new NullBorderRenderer();
        } else {
            if (this.border.getStrokeSize() == -1) {
                this.border = new DefaultBorderRenderer();
            }
            this.border.setStrokeSize(size);
        }
    }

    @Override
    public void invalidate(GL2 gl) {
        this.shape.invalidate();
    }
}

