/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.scene.Camera;
import saf.v3d.scene.VComposite;
import saf.v3d.scene.VSpatial;

public class VRoot
extends VComposite {
    private Camera camera;
    private Vector3f cameraTrans = new Vector3f();

    public VRoot(Camera camera) {
        this.children = new LinkedHashSet();
        this.camera = camera;
        this.parent = null;
    }

    private void doUpdateWorldTransformation() {
        if (this.dirty) {
            this.worldScale = this.localScale;
            this.worldRotation.set(this.localRotation);
            this.worldRotation.mul(this.camera.rotation);
            Matrix3f matrix = new Matrix3f(this.camera.rotation);
            Vector3f trans = new Vector3f(this.localTrans);
            matrix.transform((Tuple3f)trans);
            trans.scale(this.camera.getScale());
            this.camera.getTranslate(this.cameraTrans);
            this.worldTrans.set((Tuple3f)this.cameraTrans);
            this.worldTrans.add((Tuple3f)trans);
        }
        this.dirty = false;
    }

    @Override
    protected BoundingSphere doGetBoundingSphere() {
        if (this.children.isEmpty()) {
            return new BoundingSphere(new Point3f(), 0.0f);
        }
        Iterator iter = this.children.iterator();
        BoundingSphere sphere = new BoundingSphere(((VSpatial)iter.next()).doGetBoundingSphere());
        while (iter.hasNext()) {
            sphere.merge(((VSpatial)iter.next()).doGetBoundingSphere());
        }
        return sphere;
    }

    @Override
    public void updateWorldTransformation() {
        this.doUpdateWorldTransformation();
        for (VSpatial child : this.children) {
            child.updateWorldTransformation();
        }
    }
}

