/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import com.jogamp.opengl.util.awt.TextRenderer;
import java.awt.Font;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.scene.Label;
import saf.v3d.scene.VSpatial;

public class VLabelLayer
extends VSpatial {
    private TextRenderer txtRenderer;
    private boolean invalid = true;
    private Font font;
    private boolean antialiased = true;
    private Set<Label> labels = new HashSet<Label>();

    public VLabelLayer(Font font) {
        this(font, true);
    }

    public VLabelLayer(Font font, boolean antialias) {
        this.boundingSphere = new BoundingSphere(new Point3f(0.0f, 0.0f, 0.0f), 0.0f);
        this.font = font;
        this.antialiased = antialias;
    }

    private void init() {
        if (this.txtRenderer != null) {
            this.txtRenderer.dispose();
        }
        this.txtRenderer = new TextRenderer(this.font, this.antialiased, true);
    }

    @Override
    public void invalidate(GL2 gl) {
        if (this.txtRenderer != null) {
            this.txtRenderer.dispose();
        }
        this.txtRenderer = null;
        this.invalid = true;
    }

    public void addLabel(Label label) {
        this.labels.add(label);
    }

    public void removeLabel(Label label) {
        this.labels.remove(label);
    }

    @Override
    protected void doDraw(GL2 gl, RenderState rState) {
        if (this.visible) {
            if (this.txtRenderer == null || this.invalid) {
                this.init();
            }
            this.txtRenderer.begin3DRendering();
            for (Label label : this.labels) {
                label.drawText(this.txtRenderer);
            }
            this.txtRenderer.end3DRendering();
        }
    }

    @Override
    public void intersects(Point3f point, Accumulator accumulator) {
    }

    @Override
    public void intersects(Point3f rayOrigin, Vector3f rayDirection, Accumulator accumulator) {
    }
}

