/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL2;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.AppearanceFactory;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.render.Texture2D;
import saf.v3d.scene.TextureRenderable;
import saf.v3d.scene.VSpatial;

public class VImage2D
extends VSpatial
implements TextureRenderable {
    private Texture2D texture;

    public VImage2D(Texture2D texture) {
        this.texture = texture;
        this.appearance = AppearanceFactory.DO_NOTHING_APPEARANCE;
        this.boundingSphere = texture.getBounds();
    }

    @Override
    public Texture2D getTextureData() {
        return this.texture;
    }

    @Override
    protected void doDraw(GL2 gl, RenderState rState) {
        this.texture.draw(gl, rState);
    }

    @Override
    public void intersects(Point3f point, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(point)) {
            Point3f localPt = new Point3f(point);
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            matrix.setRotation(this.worldRotation);
            matrix.setScale(this.worldScale);
            matrix.setTranslation(this.worldTrans);
            Matrix4f invert = new Matrix4f();
            invert.setIdentity();
            invert.invert(matrix);
            matrix.setTranslation(this.worldTrans);
            invert.setIdentity();
            invert.invert(matrix);
            invert.transform(localPt);
            if (new Rectangle2D.Float(-this.texture.getWidth() / 2.0f, -this.texture.getHeight() / 2.0f, this.texture.getWidth(), this.texture.getHeight()).contains(new Point2D.Float(localPt.x, localPt.y))) {
                accumulator.add(this);
            }
        }
    }

    @Override
    public void intersects(Point3f rayOrigin, Vector3f rayDirection, Accumulator accumulator) {
        throw new UnsupportedOperationException();
    }
}

