/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import saf.v3d.render.RenderState;
import saf.v3d.scene.VEdge2D;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VSpatial;

public class VEdgeLayer
extends VLayer {
    private static int FLOATS_PER_EDGE = 10;
    private static int INIT_CAPACITY = 1000;
    private int vboIndex = 0;
    private int capacity = INIT_CAPACITY;
    private boolean invalid = true;

    private void init(GL gl) {
        if (this.vboIndex != 0) {
            gl.glDeleteBuffers(1, new int[]{this.vboIndex}, 0);
        }
        int[] indices = new int[1];
        gl.glGenBuffers(1, indices, 0);
        this.vboIndex = indices[0];
        gl.glBindBuffer(34962, this.vboIndex);
        int bufSize = this.capacity * FLOATS_PER_EDGE * 4;
        gl.glBufferData(34962, (long)bufSize, null, 35040);
        this.invalid = false;
    }

    @Override
    public void invalidate(GL2 gl) {
        this.invalid = true;
    }

    @Override
    public void addChild(VSpatial child) {
        if (this.children.size() == this.capacity) {
            this.capacity += INIT_CAPACITY / 2;
            this.invalid = true;
        }
        super.addChild(child);
    }

    @Override
    public void addChildren(VSpatial ... items) {
        super.addChildren(items);
    }

    @Override
    protected void doDraw(GL2 gl, RenderState rState) {
        if (this.visible) {
            if (this.vboIndex == 0 || this.invalid) {
                this.init((GL)gl);
            }
            if (this.children.size() > 0) {
                HashMap<Float, Object> map = new HashMap<Float, Object>();
                ArrayList<VEdge2D> ones = new ArrayList<VEdge2D>();
                for (VSpatial item : this.children) {
                    VEdge2D edge = (VEdge2D)item;
                    edge.doDraw(gl, rState);
                    float val = edge.getEdgeWidth();
                    if ((double)val == 1.0) {
                        ones.add(edge);
                        continue;
                    }
                    ArrayList<Object> list = (ArrayList<Object>)map.get(Float.valueOf(val));
                    if (list == null) {
                        list = new ArrayList<Object>();
                        map.put(Float.valueOf(val), list);
                    }
                    list.add(edge);
                }
                map.put(Float.valueOf(1.0f), ones);
                gl.glBindBuffer(34962, this.vboIndex);
                ByteBuffer buf = gl.glMapBuffer(34962, 35001);
                buf.position(0);
                for (List list : map.values()) {
                    for (VEdge2D edge : list) {
                        edge.updateBuffer(buf);
                    }
                }
                gl.glUnmapBuffer(34962);
                gl.glVertexPointer(2, 5126, 20, 0L);
                gl.glColorPointer(3, 5126, 20, 8L);
                gl.glEnableClientState(32884);
                gl.glEnableClientState(32886);
                int start = 0;
                for (Map.Entry vals : map.entrySet()) {
                    gl.glLineWidth(((Float)vals.getKey()).floatValue());
                    int end = ((List)vals.getValue()).size() * 2;
                    gl.glDrawArrays(1, start, end);
                    start = end;
                }
                gl.glDisableClientState(32886);
                gl.glDisableClientState(32884);
                gl.glBindBuffer(34962, 0);
            }
        }
    }
}

