/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.nio.ByteBuffer;
import javax.media.opengl.GL2;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.scene.ArrowHead2D;
import saf.v3d.scene.ColorAppearance;
import saf.v3d.scene.EdgeHead;
import saf.v3d.scene.EmptyEdgeHead;
import saf.v3d.scene.VGeometry;
import saf.v3d.scene.VSpatial;
import saf.v3d.util.Utils3D;

public class VEdge2D
extends VGeometry {
    private static final float DELTA = 0.75f;
    private VSpatial source;
    private VSpatial target;
    private Point3f sourcePt;
    private Point3f targetPt;
    private int edgeWidth = 1;
    private EdgeHead head = new EmptyEdgeHead();

    public VEdge2D(VSpatial source, VSpatial target) {
        this(source, target, false);
    }

    public VEdge2D(VSpatial source, VSpatial target, boolean directed) {
        this.source = source;
        this.target = target;
        this.sourcePt = new Point3f();
        this.targetPt = new Point3f();
        if (directed) {
            this.head = new ArrowHead2D(this.sourcePt, this.targetPt);
        }
    }

    public void setEdgeWidth(int width) {
        this.edgeWidth = width;
    }

    public int getEdgeWidth() {
        return this.edgeWidth;
    }

    public void update() {
        BoundingSphere sourceSphere = this.source.getLocalBoundingSphere();
        this.sourcePt.set((Tuple3f)sourceSphere.getCenterRef());
        this.source.transform(this.sourcePt);
        BoundingSphere targetSphere = this.target.getLocalBoundingSphere();
        this.targetPt.set((Tuple3f)targetSphere.getCenterRef());
        this.target.transform(this.targetPt);
        this.updatePoint(this.sourcePt, this.targetPt, sourceSphere.getRadius() * this.source.getLocalScale());
        this.updatePoint(this.targetPt, this.sourcePt, targetSphere.getRadius() * this.target.getLocalScale());
        this.head.update(this.edgeWidth);
    }

    private void updatePoint(Point3f pointToUpdate, Point3f otherPt, float radius) {
        double deltaX = pointToUpdate.x - otherPt.x;
        double deltaY = pointToUpdate.y - otherPt.y;
        if (pointToUpdate.distanceSquared(otherPt) > radius * radius) {
            if (deltaX == 0.0) {
                if (deltaY > 0.0) {
                    pointToUpdate.setY(pointToUpdate.y - radius);
                } else {
                    pointToUpdate.setY(pointToUpdate.y + radius);
                }
            } else {
                double theta = Math.atan(deltaY / deltaX);
                if (otherPt.x < pointToUpdate.x) {
                    theta += Math.PI;
                }
                pointToUpdate.set(pointToUpdate.x + radius * (float)Math.cos(theta), pointToUpdate.y + radius * (float)Math.sin(theta), 0.0f);
            }
        }
    }

    @Override
    protected BoundingSphere doGetBoundingSphere() {
        BoundingSphere sphere = new BoundingSphere(this.source.doGetBoundingSphere());
        sphere.merge(this.target.doGetBoundingSphere());
        return sphere;
    }

    public void updateBuffer(ByteBuffer buf) {
        this.update();
        ColorAppearance color = (ColorAppearance)this.appearance;
        buf.putFloat(this.sourcePt.x);
        buf.putFloat(this.sourcePt.y);
        buf.putFloat(color.getRed());
        buf.putFloat(color.getGreen());
        buf.putFloat(color.getBlue());
        buf.putFloat(this.targetPt.x);
        buf.putFloat(this.targetPt.y);
        buf.putFloat(color.getRed());
        buf.putFloat(color.getGreen());
        buf.putFloat(color.getBlue());
    }

    @Override
    protected void doDraw(GL2 gl, RenderState rState) {
        this.head.draw(gl, this.appearance);
    }

    @Override
    protected boolean intersects(Point3f rayOrigin, Vector3f rayDirection) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    @Override
    protected boolean intersects(Point3f point) {
        float distSq = Utils3D.distanceSquared(point, this.sourcePt, this.targetPt);
        if (distSq <= 0.75f) {
            return true;
        }
        return this.head.intersects(point);
    }
}

