/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.media.opengl.GL2;
import saf.v3d.render.RenderState;
import saf.v3d.render.Texture2D;
import saf.v3d.scene.TextureRenderable;
import saf.v3d.scene.VSpatial;

public class TextureLayerCollection
implements Collection<VSpatial> {
    private Map<Texture2D, Set<VSpatial>> images = new HashMap<Texture2D, Set<VSpatial>>();
    private int size = 0;

    public void invalidate(GL2 gl) {
        for (Map.Entry<Texture2D, Set<VSpatial>> entry : this.images.entrySet()) {
            entry.getKey().dispose(gl);
        }
    }

    public void draw(GL2 gl, RenderState state) {
        int target = -1;
        for (Map.Entry<Texture2D, Set<VSpatial>> entry : this.images.entrySet()) {
            Texture2D tex = entry.getKey();
            if (target == -1) {
                target = tex.enable(gl);
            } else if (target != tex.getTarget(gl)) {
                gl.glDisable(target);
                target = tex.enable(gl);
            }
            tex.bind(gl);
            Set<VSpatial> set = entry.getValue();
            for (VSpatial img : set) {
                img.draw(gl, state);
            }
        }
        if (target != -1) {
            gl.glDisable(target);
        }
    }

    @Override
    public boolean add(VSpatial obj) {
        TextureRenderable image = (TextureRenderable)((Object)obj);
        Set<VSpatial> set = this.images.get(image.getTextureData());
        if (set == null) {
            set = new HashSet<VSpatial>();
            this.images.put(image.getTextureData(), set);
        }
        set.add(obj);
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends VSpatial> c) {
        for (VSpatial vSpatial : c) {
            this.add(vSpatial);
        }
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.images.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof TextureRenderable)) {
            return false;
        }
        TextureRenderable image = (TextureRenderable)o;
        Set<VSpatial> set = this.images.get(image.getTextureData());
        return set != null && set.contains(image);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<VSpatial> iterator() {
        return new Iter();
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof TextureRenderable)) {
            return false;
        }
        TextureRenderable image = (TextureRenderable)o;
        Set<VSpatial> set = this.images.get(image.getTextureData());
        if (set != null && set.remove(o)) {
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int i = 0;
        for (VSpatial image : this) {
            array[i] = image;
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    class Iter
    implements Iterator<VSpatial> {
        private Iterator<Set<VSpatial>> valuesIter;
        private Iterator<VSpatial> iter;
        private VSpatial obj = null;

        public Iter() {
            this.valuesIter = TextureLayerCollection.this.images.values().iterator();
            while (this.obj == null && this.valuesIter.hasNext()) {
                this.iter = this.valuesIter.next().iterator();
                if (!this.iter.hasNext()) continue;
                this.obj = this.iter.next();
            }
        }

        private void findNext() {
            this.obj = null;
            while (this.obj == null) {
                if (this.iter.hasNext()) {
                    this.obj = this.iter.next();
                    continue;
                }
                if (!this.valuesIter.hasNext()) break;
                this.iter = this.valuesIter.next().iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.obj != null;
        }

        @Override
        public VSpatial next() {
            if (this.obj == null) {
                throw new NoSuchElementException();
            }
            VSpatial tmp = this.obj;
            this.findNext();
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

