/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.render;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import saf.v3d.render.PolygonRenderer;
import saf.v3d.render.PolygonShape;
import saf.v3d.render.RenderData;
import saf.v3d.render.RenderState;
import saf.v3d.render.Shape;
import saf.v3d.render.TriangleIterator;

public class VertexVBORenderer
implements PolygonRenderer {
    private int vboIndex;
    private RenderData renderData;
    private boolean invalid = true;

    public VertexVBORenderer(RenderData data) {
        this.renderData = data;
    }

    @Override
    public void invalidate() {
        this.invalid = true;
    }

    private void initVBO(GL gl) {
        int[] indices = new int[1];
        gl.glGenBuffers(1, indices, 0);
        this.vboIndex = indices[0];
        gl.glBindBuffer(34962, this.vboIndex);
        FloatBuffer buf = this.renderData.getVertices();
        buf.rewind();
        gl.glBufferData(34962, (long)(buf.capacity() * 3 * 4), (Buffer)buf, 35044);
        this.invalid = false;
    }

    public VertexVBORenderer(FloatBuffer vertices, int mode) {
        this.renderData = new RenderData(vertices);
        this.renderData.defineSlice(mode, 0);
    }

    @Override
    public void dispose(GL2 gl) {
        if (this.vboIndex != 0) {
            gl.glDeleteBuffers(1, new int[]{this.vboIndex}, 0);
            this.invalid = true;
        }
    }

    @Override
    public void render(GL2 gl, RenderState rState) {
        if (this.invalid) {
            this.initVBO((GL)gl);
        }
        gl.glEnableClientState(32884);
        if (rState.vboIndex != this.vboIndex) {
            gl.glBindBuffer(34962, this.vboIndex);
            rState.vboIndex = this.vboIndex;
        }
        this.renderData.renderVBO(gl);
        gl.glDisableClientState(32884);
    }

    @Override
    public TriangleIterator triangleIterator() {
        return this.renderData.triangleIterator();
    }

    @Override
    public FloatBuffer getVertices() {
        return this.renderData.getVertices();
    }

    @Override
    public Shape createShape() {
        return new PolygonShape(this);
    }
}

